/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SAMUtils;
import java.io.Serializable;
import java.util.Arrays;

public class SAMBinaryTagAndValue
implements Serializable {
    public static final long serialVersionUID = 1L;
    public final short tag;
    public final Object value;
    protected SAMBinaryTagAndValue next = null;

    public SAMBinaryTagAndValue(short s, Object object) {
        if (null == object) {
            throw new IllegalArgumentException("SAMBinaryTagAndValue value may not be null");
        }
        if (!SAMBinaryTagAndValue.isAllowedAttributeValue(object)) {
            throw new IllegalArgumentException("Attribute type " + object.getClass() + " not supported. Tag: " + SAMTagUtil.getSingleton().makeStringTag(s));
        }
        this.tag = s;
        this.value = object;
    }

    protected static boolean isAllowedAttributeValue(Object object) {
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof String || object instanceof Character || object instanceof Float || object instanceof byte[] || object instanceof short[] || object instanceof int[] || object instanceof float[]) {
            return true;
        }
        if (object instanceof Long) {
            return SAMUtils.isValidUnsignedIntegerAttribute((Long)object) || (Long)object >= Integer.MIN_VALUE && (Long)object <= Integer.MAX_VALUE;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeSafeEquals((SAMBinaryTagAndValue)object);
    }

    private boolean typeSafeEquals(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        if (this.tag != sAMBinaryTagAndValue.tag) {
            return false;
        }
        if (this.valueEquals(sAMBinaryTagAndValue)) {
            if (this.next == null) {
                return sAMBinaryTagAndValue.next == null;
            }
            return this.next.equals(sAMBinaryTagAndValue.next);
        }
        return false;
    }

    private boolean valueEquals(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        if (this.value instanceof byte[]) {
            return sAMBinaryTagAndValue.value instanceof byte[] ? Arrays.equals((byte[])this.value, (byte[])sAMBinaryTagAndValue.value) : false;
        }
        if (this.value instanceof short[]) {
            return sAMBinaryTagAndValue.value instanceof short[] ? Arrays.equals((short[])this.value, (short[])sAMBinaryTagAndValue.value) : false;
        }
        if (this.value instanceof int[]) {
            return sAMBinaryTagAndValue.value instanceof int[] ? Arrays.equals((int[])this.value, (int[])sAMBinaryTagAndValue.value) : false;
        }
        if (this.value instanceof float[]) {
            return sAMBinaryTagAndValue.value instanceof float[] ? Arrays.equals((float[])this.value, (float[])sAMBinaryTagAndValue.value) : false;
        }
        return this.value.equals(sAMBinaryTagAndValue.value);
    }

    public int hashCode() {
        int n = this.value instanceof byte[] ? Arrays.hashCode((byte[])this.value) : (this.value instanceof short[] ? Arrays.hashCode((short[])this.value) : (this.value instanceof int[] ? Arrays.hashCode((int[])this.value) : (this.value instanceof float[] ? Arrays.hashCode((float[])this.value) : this.value.hashCode())));
        return 31 * this.tag + n;
    }

    public SAMBinaryTagAndValue copy() {
        SAMBinaryTagAndValue sAMBinaryTagAndValue = new SAMBinaryTagAndValue(this.tag, this.value);
        if (this.next != null) {
            sAMBinaryTagAndValue.next = this.next.copy();
        }
        return sAMBinaryTagAndValue;
    }

    public SAMBinaryTagAndValue deepCopy() {
        SAMBinaryTagAndValue sAMBinaryTagAndValue = new SAMBinaryTagAndValue(this.tag, this.cloneValue());
        if (this.next != null) {
            sAMBinaryTagAndValue.next = this.next.deepCopy();
        }
        return sAMBinaryTagAndValue;
    }

    protected Object cloneValue() {
        Object object = this.value instanceof byte[] ? ((byte[])this.value).clone() : (this.value instanceof short[] ? ((short[])this.value).clone() : (this.value instanceof int[] ? ((int[])this.value).clone() : (this.value instanceof float[] ? ((float[])this.value).clone() : this.value)));
        return object;
    }

    public SAMBinaryTagAndValue getNext() {
        return this.next;
    }

    public SAMBinaryTagAndValue insert(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        if (sAMBinaryTagAndValue == null) {
            return this;
        }
        if (sAMBinaryTagAndValue.next != null) {
            throw new IllegalStateException("Can only insert single tag/value combinations.");
        }
        if (sAMBinaryTagAndValue.tag < this.tag) {
            sAMBinaryTagAndValue.next = this;
            return sAMBinaryTagAndValue;
        }
        if (this.tag == sAMBinaryTagAndValue.tag) {
            sAMBinaryTagAndValue.next = this.next;
            return sAMBinaryTagAndValue;
        }
        if (this.next == null) {
            this.next = sAMBinaryTagAndValue;
            return this;
        }
        this.next = this.next.insert(sAMBinaryTagAndValue);
        return this;
    }

    public SAMBinaryTagAndValue remove(short s) {
        if (this.tag == s) {
            return this.next;
        }
        if (this.next != null) {
            this.next = this.next.remove(s);
        }
        return this;
    }

    public SAMBinaryTagAndValue find(short s) {
        if (this.tag == s) {
            return this;
        }
        if (this.tag > s || this.next == null) {
            return null;
        }
        return this.next.find(s);
    }

    public boolean isUnsignedArray() {
        return false;
    }
}

