/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AsyncSAMFileWriter;
import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.CRAMFileWriter;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SAMFileWriterFactory
implements Cloneable {
    private static final Log log = Log.getInstance(SAMFileWriterFactory.class);
    private static boolean defaultCreateIndexWhileWriting = Defaults.CREATE_INDEX;
    private boolean createIndex = defaultCreateIndexWhileWriting;
    private static boolean defaultCreateMd5File = Defaults.CREATE_MD5;
    private boolean createMd5File = defaultCreateMd5File;
    private boolean useAsyncIo = Defaults.USE_ASYNC_IO_FOR_SAMTOOLS;
    private int asyncOutputBufferSize = 2000;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private File tmpDir;
    private int compressionLevel = BlockCompressedOutputStream.getDefaultCompressionLevel();
    private Integer maxRecordsInRam = null;

    public SAMFileWriterFactory() {
    }

    public SAMFileWriterFactory(SAMFileWriterFactory sAMFileWriterFactory) {
        if (sAMFileWriterFactory == null) {
            throw new IllegalArgumentException("SAMFileWriterFactory(null)");
        }
        this.createIndex = sAMFileWriterFactory.createIndex;
        this.createMd5File = sAMFileWriterFactory.createMd5File;
        this.useAsyncIo = sAMFileWriterFactory.useAsyncIo;
        this.asyncOutputBufferSize = sAMFileWriterFactory.asyncOutputBufferSize;
        this.bufferSize = sAMFileWriterFactory.bufferSize;
        this.tmpDir = sAMFileWriterFactory.tmpDir;
        this.compressionLevel = sAMFileWriterFactory.compressionLevel;
        this.maxRecordsInRam = sAMFileWriterFactory.maxRecordsInRam;
    }

    public SAMFileWriterFactory clone() {
        return new SAMFileWriterFactory(this);
    }

    public static void setDefaultCreateMd5File(boolean bl) {
        defaultCreateMd5File = bl;
    }

    public SAMFileWriterFactory setCreateMd5File(boolean bl) {
        this.createMd5File = bl;
        return this;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = Math.min(9, Math.max(0, n));
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public static void setDefaultCreateIndexWhileWriting(boolean bl) {
        defaultCreateIndexWhileWriting = bl;
    }

    public SAMFileWriterFactory setCreateIndex(boolean bl) {
        this.createIndex = bl;
        return this;
    }

    public SAMFileWriterFactory setMaxRecordsInRam(int n) {
        this.maxRecordsInRam = n;
        return this;
    }

    public SAMFileWriterFactory setUseAsyncIo(boolean bl) {
        this.useAsyncIo = bl;
        return this;
    }

    public SAMFileWriterFactory setAsyncOutputBufferSize(int n) {
        this.asyncOutputBufferSize = n;
        return this;
    }

    public SAMFileWriterFactory setBufferSize(int n) {
        this.bufferSize = n;
        return this;
    }

    public SAMFileWriterFactory setTempDirectory(File file) {
        this.tmpDir = file;
        return this;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        return this.makeBAMWriter(sAMFileHeader, bl, file, this.getCompressionLevel());
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file, int n) {
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4 = bl3 = this.createMd5File && IOUtil.isRegularPath(file);
            if (this.createMd5File && !bl3) {
                log.warn("Cannot create MD5 file for BAM because output file is not a regular file: " + file.getAbsolutePath());
            }
            OutputStream outputStream = IOUtil.maybeBufferOutputStream(new FileOutputStream(file, false), this.bufferSize);
            if (bl3) {
                outputStream = new Md5CalculatingOutputStream(outputStream, new File(file.getAbsolutePath() + ".md5"));
            }
            BAMFileWriter bAMFileWriter = new BAMFileWriter(outputStream, file, n);
            boolean bl5 = bl2 = this.createIndex && IOUtil.isRegularPath(file);
            if (this.createIndex && !bl2) {
                log.warn("Cannot create index for BAM because output file is not a regular file: " + file.getAbsolutePath());
            }
            if (this.tmpDir != null) {
                bAMFileWriter.setTempDirectory(this.tmpDir);
            }
            this.initializeBAMWriter(bAMFileWriter, sAMFileHeader, bl, bl2);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(bAMFileWriter, this.asyncOutputBufferSize);
            }
            return bAMFileWriter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error opening file: " + file.getAbsolutePath());
        }
    }

    private void initializeBAMWriter(BAMFileWriter bAMFileWriter, SAMFileHeader sAMFileHeader, boolean bl, boolean bl2) {
        bAMFileWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        if (this.maxRecordsInRam != null) {
            bAMFileWriter.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        bAMFileWriter.setHeader(sAMFileHeader);
        if (bl2 && bAMFileWriter.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            bAMFileWriter.enableBamIndexConstruction();
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        try {
            SAMTextWriter sAMTextWriter = this.createMd5File ? new SAMTextWriter(new Md5CalculatingOutputStream(new FileOutputStream(file, false), new File(file.getAbsolutePath() + ".md5"))) : new SAMTextWriter(file);
            sAMTextWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
            if (this.maxRecordsInRam != null) {
                sAMTextWriter.setMaxRecordsInRam(this.maxRecordsInRam);
            }
            sAMTextWriter.setHeader(sAMFileHeader);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(sAMTextWriter, this.asyncOutputBufferSize);
            }
            return sAMTextWriter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error opening file: " + file.getAbsolutePath());
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader sAMFileHeader, boolean bl, OutputStream outputStream) {
        return this.initWriter(sAMFileHeader, bl, false, new SAMTextWriter(outputStream));
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, OutputStream outputStream) {
        return this.initWriter(sAMFileHeader, bl, true, new BAMFileWriter(outputStream, null, this.getCompressionLevel()));
    }

    private SAMFileWriter initWriter(SAMFileHeader sAMFileHeader, boolean bl, boolean bl2, SAMFileWriterImpl sAMFileWriterImpl) {
        sAMFileWriterImpl.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        if (this.maxRecordsInRam != null) {
            sAMFileWriterImpl.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        sAMFileWriterImpl.setHeader(sAMFileHeader);
        if (this.useAsyncIo) {
            return new AsyncSAMFileWriter(sAMFileWriterImpl, this.asyncOutputBufferSize);
        }
        return sAMFileWriterImpl;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        String string = file.getName();
        if (string.endsWith(".bam")) {
            return this.makeBAMWriter(sAMFileHeader, bl, file);
        }
        if (string.endsWith(".sam")) {
            return this.makeSAMWriter(sAMFileHeader, bl, file);
        }
        return this.makeBAMWriter(sAMFileHeader, bl, file);
    }

    public SAMFileWriter makeWriter(SAMFileHeader sAMFileHeader, boolean bl, File file, File file2) {
        if (file.getName().endsWith(SamReader.Type.CRAM_TYPE.fileExtension())) {
            return this.makeCRAMWriter(sAMFileHeader, bl, file, file2);
        }
        return this.makeSAMOrBAMWriter(sAMFileHeader, bl, file);
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader sAMFileHeader, OutputStream outputStream, File file) {
        CRAMFileWriter cRAMFileWriter = new CRAMFileWriter(outputStream, new ReferenceSource(file), sAMFileHeader, null);
        this.setCRAMWriterDefaults(cRAMFileWriter);
        return cRAMFileWriter;
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader sAMFileHeader, File file, File file2) {
        return this.createCRAMWriterWithSettings(sAMFileHeader, true, file, file2);
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file, File file2) {
        return this.createCRAMWriterWithSettings(sAMFileHeader, bl, file, file2);
    }

    private CRAMFileWriter createCRAMWriterWithSettings(SAMFileHeader sAMFileHeader, boolean bl, File file, File file2) {
        Object object;
        OutputStream outputStream = null;
        FileOutputStream fileOutputStream = null;
        if (this.createIndex) {
            if (!IOUtil.isRegularPath(file)) {
                log.warn("Cannot create index for CRAM because output file is not a regular file: " + file.getAbsolutePath());
            } else {
                try {
                    object = new File(file.getAbsolutePath() + ".bai");
                    fileOutputStream = new FileOutputStream((File)object);
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException("Error creating index file for: " + file.getAbsolutePath() + ".bai");
                }
            }
        }
        try {
            outputStream = IOUtil.maybeBufferOutputStream(new FileOutputStream(file, false), this.bufferSize);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error creating CRAM file: " + file.getAbsolutePath());
        }
        object = new CRAMFileWriter(this.createMd5File ? new Md5CalculatingOutputStream(outputStream, new File(file.getAbsolutePath() + ".md5")) : outputStream, fileOutputStream, bl, new ReferenceSource(file2), sAMFileHeader, file.getAbsolutePath());
        this.setCRAMWriterDefaults((CRAMFileWriter)object);
        return object;
    }

    private void setCRAMWriterDefaults(CRAMFileWriter cRAMFileWriter) {
        cRAMFileWriter.setPreserveReadNames(true);
        cRAMFileWriter.setCaptureAllTags(true);
    }

    public String toString() {
        return "SAMFileWriterFactory [createIndex=" + this.createIndex + ", createMd5File=" + this.createMd5File + ", useAsyncIo=" + this.useAsyncIo + ", asyncOutputBufferSize=" + this.asyncOutputBufferSize + ", bufferSize=" + this.bufferSize + ", tmpDir=" + this.tmpDir + ", compressionLevel=" + this.compressionLevel + ", maxRecordsInRam=" + this.maxRecordsInRam + "]";
    }
}

