/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

class HuffmanParamsCalculator {
    private final HashMap<Integer, MutableInt> countMap = new HashMap();
    private int[] values = new int[0];
    private int[] bitLens = new int[0];

    HuffmanParamsCalculator() {
    }

    public void add(int n) {
        MutableInt mutableInt = this.countMap.get(n);
        if (mutableInt == null) {
            mutableInt = new MutableInt();
            this.countMap.put(n, mutableInt);
        }
        ++mutableInt.value;
    }

    public void add(Integer n, int n2) {
        MutableInt mutableInt = this.countMap.get(n);
        if (mutableInt == null) {
            mutableInt = new MutableInt();
            this.countMap.put(n, mutableInt);
        }
        mutableInt.value += n2;
    }

    public int[] bitLens() {
        return this.bitLens;
    }

    public int[] values() {
        return this.values;
    }

    public Integer[] valuesAsAutoIntegers() {
        Integer[] integerArray = new Integer[this.values.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = this.values[i];
        }
        return integerArray;
    }

    public byte[] valuesAsBytes() {
        byte[] byArray = new byte[this.values.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(0xFF & this.values[i]);
        }
        return byArray;
    }

    public Byte[] valuesAsAutoBytes() {
        Byte[] byteArray = new Byte[this.values.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = (byte)(0xFF & this.values[i]);
        }
        return byteArray;
    }

    public void calculate() {
        int n = this.countMap.size();
        Object object = new int[n];
        Object[] objectArray = new int[n];
        int n2 = 0;
        for (Integer n3 : this.countMap.keySet()) {
            objectArray[n2] = n3;
            object[n2] = this.countMap.get((Object)n3).value;
            ++n2;
        }
        HuffmanTree<Integer> huffmanTree = HuffmanCode.buildTree((int[])object, HuffmanParamsCalculator.autobox(objectArray));
        ArrayList arrayList = new ArrayList();
        object = new ArrayList();
        HuffmanCode.getValuesAndBitLengths(arrayList, (List<Integer>)object, huffmanTree);
        objectArray = new BitCode[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            objectArray[n2] = (int)new BitCode((Integer)arrayList.get(n2), (Integer)object.get(n2));
        }
        Arrays.sort(objectArray);
        this.values = new int[objectArray.length];
        this.bitLens = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            Object object2 = objectArray[n2];
            this.bitLens[n2] = ((BitCode)object2).length;
            this.values[n2] = ((BitCode)object2).value;
        }
    }

    private static Integer[] autobox(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    private static class BitCode
    implements Comparable<BitCode> {
        final int value;
        final int length;

        public BitCode(int n, int n2) {
            this.value = n;
            this.length = n2;
        }

        @Override
        public int compareTo(BitCode bitCode) {
            int n = this.value - bitCode.value;
            if (n != 0) {
                return n;
            }
            return this.length - bitCode.length;
        }
    }
}

