/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

public class BlockCompressedFilePointerUtil {
    private static final int SHIFT_AMOUNT = 16;
    private static final int OFFSET_MASK = 65535;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFL;
    public static final long MAX_BLOCK_ADDRESS = 0xFFFFFFFFFFFFL;
    public static final int MAX_OFFSET = 65535;

    public static int compare(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l < 0L && l2 >= 0L) {
            return 1;
        }
        if (l >= 0L && l2 < 0L) {
            return -1;
        }
        if (l < l2) {
            return -1;
        }
        return 1;
    }

    public static boolean areInSameOrAdjacentBlocks(long l, long l2) {
        long l3;
        long l4 = BlockCompressedFilePointerUtil.getBlockAddress(l);
        return l4 == (l3 = BlockCompressedFilePointerUtil.getBlockAddress(l2)) || l4 + 1L == l3;
    }

    static long makeFilePointer(long l, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative blockOffset " + n + " not allowed.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative blockAddress " + l + " not allowed.");
        }
        if (n > 65535) {
            throw new IllegalArgumentException("blockOffset " + n + " too large.");
        }
        if (l > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("blockAddress " + l + " too large.");
        }
        return l << 16 | (long)n;
    }

    public static long getBlockAddress(long l) {
        return l >> 16 & 0xFFFFFFFFFFFFL;
    }

    public static int getBlockOffset(long l) {
        return (int)(l & 0xFFFFL);
    }

    public static String asString(long l) {
        return String.format("%d(0x%x): (block address: %d, offset: %d)", l, l, BlockCompressedFilePointerUtil.getBlockAddress(l), BlockCompressedFilePointerUtil.getBlockOffset(l));
    }
}

