/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class GenotypesContext
implements List<Genotype>,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final GenotypesContext NO_GENOTYPES = new GenotypesContext(new ArrayList<Genotype>(0), new HashMap<String, Integer>(0), Collections.emptyList()).immutable();
    protected List<String> sampleNamesInOrder = null;
    protected Map<String, Integer> sampleNameToOffset = null;
    protected ArrayList<Genotype> notToBeDirectlyAccessedGenotypes;
    private int maxPloidy = -1;
    private boolean immutable = false;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == LazyGenotypesContext.class) {
            ((LazyGenotypesContext)this).decode();
        }
        objectOutputStream.defaultWriteObject();
    }

    protected GenotypesContext() {
        this(10);
    }

    protected GenotypesContext(int n) {
        this(new ArrayList<Genotype>(n));
    }

    protected GenotypesContext(ArrayList<Genotype> arrayList) {
        this.notToBeDirectlyAccessedGenotypes = arrayList;
        this.sampleNameToOffset = null;
    }

    protected GenotypesContext(ArrayList<Genotype> arrayList, Map<String, Integer> map, List<String> list) {
        this.notToBeDirectlyAccessedGenotypes = arrayList;
        this.sampleNameToOffset = map;
        this.sampleNamesInOrder = list;
    }

    public static final GenotypesContext create() {
        return new GenotypesContext();
    }

    public static final GenotypesContext create(int n) {
        return new GenotypesContext(n);
    }

    public static final GenotypesContext create(ArrayList<Genotype> arrayList, Map<String, Integer> map, List<String> list) {
        return new GenotypesContext(arrayList, map, list);
    }

    public static final GenotypesContext create(ArrayList<Genotype> arrayList) {
        return arrayList == null ? NO_GENOTYPES : new GenotypesContext(arrayList);
    }

    public static final GenotypesContext create(Genotype ... genotypeArray) {
        return GenotypesContext.create(new ArrayList<Genotype>(Arrays.asList(genotypeArray)));
    }

    public static final GenotypesContext copy(GenotypesContext genotypesContext) {
        return GenotypesContext.create(new ArrayList<Genotype>(genotypesContext.getGenotypes()));
    }

    public static final GenotypesContext copy(Collection<Genotype> collection) {
        return collection == null ? NO_GENOTYPES : GenotypesContext.create(new ArrayList<Genotype>(collection));
    }

    public final GenotypesContext immutable() {
        this.immutable = true;
        return this;
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public final void checkImmutability() {
        if (this.immutable) {
            throw new IllegalAccessError("GenotypeMap is currently immutable, but a mutator method was invoked on it");
        }
    }

    protected void invalidateSampleNameMap() {
        this.sampleNameToOffset = null;
    }

    protected void invalidateSampleOrdering() {
        this.sampleNamesInOrder = null;
    }

    protected void ensureSampleOrdering() {
        if (this.sampleNamesInOrder == null) {
            this.sampleNamesInOrder = new ArrayList<String>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.sampleNamesInOrder.add(this.getGenotypes().get(i).getSampleName());
            }
            Collections.sort(this.sampleNamesInOrder);
        }
    }

    protected void ensureSampleNameMap() {
        if (this.sampleNameToOffset == null) {
            this.sampleNameToOffset = new HashMap<String, Integer>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.sampleNameToOffset.put(this.getGenotypes().get(i).getSampleName(), i);
            }
        }
    }

    public boolean isLazyWithData() {
        return this instanceof LazyGenotypesContext && ((LazyGenotypesContext)this).getUnparsedGenotypeData() != null;
    }

    protected ArrayList<Genotype> getGenotypes() {
        return this.notToBeDirectlyAccessedGenotypes;
    }

    @Override
    public void clear() {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        this.getGenotypes().clear();
    }

    @Override
    public int size() {
        return this.getGenotypes().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getGenotypes().isEmpty();
    }

    @Override
    public boolean add(Genotype genotype) {
        this.checkImmutability();
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            this.sampleNameToOffset.put(genotype.getSampleName(), this.size());
        }
        return this.getGenotypes().add(genotype);
    }

    @Override
    public void add(int n, Genotype genotype) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Genotype> collection) {
        this.checkImmutability();
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            int n = this.size();
            for (Genotype genotype : collection) {
                this.sampleNameToOffset.put(genotype.getSampleName(), n++);
            }
        }
        return this.getGenotypes().addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Genotype> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.getGenotypes().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getGenotypes().containsAll(collection);
    }

    private boolean containsAny(Collection<? extends Genotype> collection) {
        for (Genotype genotype : collection) {
            if (!this.contains(genotype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Genotype get(int n) {
        return this.getGenotypes().get(n);
    }

    public int getMaxPloidy(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("defaultPloidy must be greater than or equal to 0");
        }
        if (this.maxPloidy == -1) {
            this.maxPloidy = 0;
            for (Genotype genotype : this.getGenotypes()) {
                this.maxPloidy = Math.max(genotype.getPloidy(), this.maxPloidy);
            }
            if (this.maxPloidy == 0) {
                this.maxPloidy = n;
            }
        }
        return this.maxPloidy;
    }

    public Genotype get(String string) {
        Integer n = this.getSampleI(string);
        return n == null ? null : this.getGenotypes().get(n);
    }

    private Integer getSampleI(String string) {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.get(string);
    }

    @Override
    public int indexOf(Object object) {
        return this.getGenotypes().indexOf(object);
    }

    @Override
    public Iterator<Genotype> iterator() {
        return this.getGenotypes().iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getGenotypes().lastIndexOf(object);
    }

    @Override
    public ListIterator<Genotype> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Genotype> listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Genotype remove(int n) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().remove(n);
    }

    @Override
    public boolean remove(Object object) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().retainAll(collection);
    }

    @Override
    public Genotype set(int n, Genotype genotype) {
        this.checkImmutability();
        Genotype genotype2 = this.getGenotypes().set(n, genotype);
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            this.sampleNameToOffset.remove(genotype2.getSampleName());
            this.sampleNameToOffset.put(genotype.getSampleName(), n);
        }
        return genotype2;
    }

    public Genotype replace(Genotype genotype) {
        this.checkImmutability();
        Integer n = this.getSampleI(genotype.getSampleName());
        if (n == null) {
            return null;
        }
        return this.set((int)n, genotype);
    }

    @Override
    public List<Genotype> subList(int n, int n2) {
        return this.getGenotypes().subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.getGenotypes().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.getGenotypes().toArray(TArray);
    }

    public Iterable<Genotype> iterateInSampleNameOrder(final Iterable<String> iterable) {
        return new Iterable<Genotype>(){

            @Override
            public Iterator<Genotype> iterator() {
                return new InOrderIterator(iterable.iterator());
            }
        };
    }

    public Iterable<Genotype> iterateInSampleNameOrder() {
        return this.iterateInSampleNameOrder(this.getSampleNamesOrderedByName());
    }

    public Set<String> getSampleNames() {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.keySet();
    }

    public List<String> getSampleNamesOrderedByName() {
        this.ensureSampleOrdering();
        return this.sampleNamesInOrder;
    }

    public boolean containsSample(String string) {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.containsKey(string);
    }

    public boolean containsSamples(Collection<String> collection) {
        return this.getSampleNames().containsAll(collection);
    }

    public GenotypesContext subsetToSamples(Set<String> set) {
        int n = set.size();
        if (n == 0) {
            return NO_GENOTYPES;
        }
        GenotypesContext genotypesContext = GenotypesContext.create(set.size());
        for (String string : set) {
            Genotype genotype = this.get(string);
            if (genotype == null) continue;
            genotypesContext.add(genotype);
        }
        return genotypesContext;
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Genotype genotype : this.iterateInSampleNameOrder()) {
            arrayList.add(genotype.toString());
        }
        return "[" + GenotypesContext.join(",", arrayList) + "]";
    }

    private static <T> String join(String string, Collection<T> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        if (!iterator.hasNext()) {
            return t.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(t.toString());
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next().toString());
        }
        return stringBuilder.toString();
    }

    private final class InOrderIterator
    implements Iterator<Genotype> {
        final Iterator<String> sampleNamesInOrder;

        private InOrderIterator(Iterator<String> iterator) {
            this.sampleNamesInOrder = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.sampleNamesInOrder.hasNext();
        }

        @Override
        public Genotype next() {
            return GenotypesContext.this.get(this.sampleNamesInOrder.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

