/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VariantContextComparator
implements Comparator<VariantContext>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> contigIndexLookup;

    public static List<String> getSequenceNameList(SAMSequenceDictionary sAMSequenceDictionary) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            arrayList.add(sAMSequenceRecord.getSequenceName());
        }
        return arrayList;
    }

    public VariantContextComparator(List<String> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("One or more contigs must be in the contig list.");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        for (String string : list) {
            hashMap.put(string, n++);
        }
        if (hashMap.size() != list.size()) {
            throw new IllegalArgumentException("There are duplicate contigs/chromosomes in the input contig list.");
        }
        this.contigIndexLookup = Collections.unmodifiableMap(hashMap);
    }

    public VariantContextComparator(Collection<VCFContigHeaderLine> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("One or more header lines must be in the header line collection.");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (VCFContigHeaderLine vCFContigHeaderLine : collection) {
            hashMap.put(vCFContigHeaderLine.getID(), vCFContigHeaderLine.getContigIndex());
        }
        if (hashMap.size() != collection.size()) {
            throw new IllegalArgumentException("There are duplicate contigs/chromosomes in the input header line collection.");
        }
        HashSet hashSet = new HashSet(hashMap.values());
        if (hashSet.size() != collection.size()) {
            throw new IllegalArgumentException("One or more contigs share the same index number.");
        }
        this.contigIndexLookup = Collections.unmodifiableMap(hashMap);
    }

    public VariantContextComparator(SAMSequenceDictionary sAMSequenceDictionary) {
        this(VariantContextComparator.getSequenceNameList(sAMSequenceDictionary));
    }

    @Override
    public int compare(VariantContext variantContext, VariantContext variantContext2) {
        int n = this.contigIndexLookup.get(variantContext.getChr()) - this.contigIndexLookup.get(variantContext2.getChr());
        return n != 0 ? n : variantContext.getStart() - variantContext2.getStart();
    }

    public boolean isCompatible(Collection<VCFContigHeaderLine> collection) {
        for (VCFContigHeaderLine vCFContigHeaderLine : collection) {
            Integer n = this.contigIndexLookup.get(vCFContigHeaderLine.getID());
            if (n != null && vCFContigHeaderLine.getContigIndex().intValue() == n.intValue()) continue;
            return false;
        }
        return true;
    }
}

