/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.writer.AsyncVariantContextWriter;
import htsjdk.variant.variantcontext.writer.BCF2Writer;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VCFWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;

public class VariantContextWriterBuilder {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);
    public static final EnumSet<OutputType> FILE_TYPES = EnumSet.of(OutputType.VCF, OutputType.BCF, OutputType.BLOCK_COMPRESSED_VCF);
    public static final EnumSet<OutputType> STREAM_TYPES = EnumSet.of(OutputType.VCF_STREAM, OutputType.BCF_STREAM);
    private SAMSequenceDictionary refDict = null;
    private OutputType outType = OutputType.UNSPECIFIED;
    private File outFile = null;
    private OutputStream outStream = null;
    private IndexCreator idxCreator = null;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private boolean createMD5 = Defaults.CREATE_MD5;
    protected EnumSet<Options> options = DEFAULT_OPTIONS.clone();

    public VariantContextWriterBuilder() {
        if (Defaults.USE_ASYNC_IO_FOR_TRIBBLE) {
            this.options.add(Options.USE_ASYNC_IO);
        }
    }

    public VariantContextWriterBuilder setReferenceDictionary(SAMSequenceDictionary sAMSequenceDictionary) {
        this.refDict = sAMSequenceDictionary;
        return this;
    }

    public VariantContextWriterBuilder setOutputFile(File file) {
        this.outFile = file;
        this.outStream = null;
        this.determineOutputTypeFromFilename();
        return this;
    }

    public VariantContextWriterBuilder setOutputFile(String string) {
        this.outFile = new File(string);
        this.outStream = null;
        this.determineOutputTypeFromFilename();
        return this;
    }

    public VariantContextWriterBuilder setOutputFileType(OutputType outputType) {
        if (!FILE_TYPES.contains((Object)outputType)) {
            throw new IllegalArgumentException("Must choose a file type, not other output types.");
        }
        if (this.outFile == null || this.outStream != null) {
            throw new IllegalArgumentException("Cannot set a file type if the output is not to a file.");
        }
        this.outType = outputType;
        return this;
    }

    public VariantContextWriterBuilder setOutputVCFStream(OutputStream outputStream) {
        this.outStream = outputStream;
        this.outFile = null;
        this.outType = OutputType.VCF_STREAM;
        return this;
    }

    public VariantContextWriterBuilder setOutputBCFStream(OutputStream outputStream) {
        this.outStream = outputStream;
        this.outFile = null;
        this.outType = OutputType.BCF_STREAM;
        return this;
    }

    public VariantContextWriterBuilder setOutputStream(OutputStream outputStream) {
        return this.setOutputVCFStream(outputStream);
    }

    public VariantContextWriterBuilder setIndexCreator(IndexCreator indexCreator) {
        this.idxCreator = indexCreator;
        return this;
    }

    public VariantContextWriterBuilder clearIndexCreator() {
        this.idxCreator = null;
        return this;
    }

    public VariantContextWriterBuilder setBuffer(int n) {
        this.bufferSize = n;
        return this;
    }

    public VariantContextWriterBuilder unsetBuffering() {
        this.bufferSize = 0;
        return this;
    }

    public VariantContextWriterBuilder setCreateMD5(boolean bl) {
        this.createMD5 = bl;
        return this;
    }

    public VariantContextWriterBuilder setCreateMD5() {
        return this.setCreateMD5(true);
    }

    public VariantContextWriterBuilder unsetCreateMD5() {
        return this.setCreateMD5(false);
    }

    public VariantContextWriterBuilder setOptions(EnumSet<Options> enumSet) {
        this.options = enumSet;
        return this;
    }

    public VariantContextWriterBuilder setOption(Options options) {
        this.options.add(options);
        return this;
    }

    public VariantContextWriterBuilder unsetOption(Options options) {
        this.options.remove((Object)options);
        return this;
    }

    public VariantContextWriterBuilder modifyOption(Options options, boolean bl) {
        return bl ? this.setOption(options) : this.unsetOption(options);
    }

    public static void setDefaultOption(Options options) {
        DEFAULT_OPTIONS.add(options);
    }

    public static void unsetDefaultOption(Options options) {
        DEFAULT_OPTIONS.remove((Object)options);
    }

    public VariantContextWriterBuilder clearOptions() {
        this.options = NO_OPTIONS.clone();
        return this;
    }

    boolean isOptionSet(Options options) {
        return this.options.contains((Object)options);
    }

    public VariantContextWriter build() {
        VariantContextWriter variantContextWriter = null;
        OutputType outputType = this.outType;
        if (this.options.contains((Object)Options.FORCE_BCF)) {
            if (FILE_TYPES.contains((Object)this.outType)) {
                outputType = OutputType.BCF;
            } else if (STREAM_TYPES.contains((Object)this.outType)) {
                outputType = OutputType.BCF_STREAM;
            }
        }
        OutputStream outputStream = this.outStream;
        if (FILE_TYPES.contains((Object)this.outType)) {
            try {
                outputStream = IOUtil.maybeBufferOutputStream(new FileOutputStream(this.outFile), this.bufferSize);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeIOException("File not found: " + this.outFile, fileNotFoundException);
            }
            if (this.createMD5) {
                outputStream = new Md5CalculatingOutputStream(outputStream, new File(this.outFile.getAbsolutePath() + ".md5"));
            }
        }
        switch (outputType) {
            case UNSPECIFIED: {
                throw new IllegalArgumentException("Must specify file or stream output type.");
            }
            case VCF: {
                if (this.refDict == null && this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("A reference dictionary is required for creating Tribble indices on the fly");
                }
                variantContextWriter = this.createVCFWriter(this.outFile, outputStream);
                break;
            }
            case BLOCK_COMPRESSED_VCF: {
                this.idxCreator = this.refDict == null ? new TabixIndexCreator(TabixFormat.VCF) : new TabixIndexCreator(this.refDict, TabixFormat.VCF);
                variantContextWriter = this.createVCFWriter(this.outFile, new BlockCompressedOutputStream(outputStream, this.outFile));
                break;
            }
            case BCF: {
                if (this.refDict == null && this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("A reference dictionary is required for creating Tribble indices on the fly");
                }
                variantContextWriter = this.createBCFWriter(this.outFile, outputStream);
                break;
            }
            case VCF_STREAM: {
                if (this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("VCF index creation not supported for stream output.");
                }
                variantContextWriter = this.createVCFWriter(null, this.outStream);
                break;
            }
            case BCF_STREAM: {
                if (this.options.contains((Object)Options.INDEX_ON_THE_FLY)) {
                    throw new IllegalArgumentException("BCF index creation not supported for stream output.");
                }
                variantContextWriter = this.createBCFWriter(null, this.outStream);
            }
        }
        if (this.options.contains((Object)Options.USE_ASYNC_IO)) {
            variantContextWriter = new AsyncVariantContextWriter(variantContextWriter, 2000);
        }
        return variantContextWriter;
    }

    private void determineOutputTypeFromFilename() {
        this.outType = this.isBCF(this.outFile) ? OutputType.BCF : (this.isCompressedVCF(this.outFile) ? OutputType.BLOCK_COMPRESSED_VCF : (this.isVCF(this.outFile) ? OutputType.VCF : OutputType.UNSPECIFIED));
    }

    private boolean isVCF(File file) {
        return file != null && file.getName().endsWith(".vcf");
    }

    private boolean isBCF(File file) {
        return file != null && file.getName().endsWith(".bcf");
    }

    private boolean isCompressedVCF(File file) {
        if (file == null) {
            return false;
        }
        return AbstractFeatureReader.hasBlockCompressedExtension(file);
    }

    private VariantContextWriter createVCFWriter(File file, OutputStream outputStream) {
        if (this.idxCreator == null) {
            return new VCFWriter(file, outputStream, this.refDict, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), this.options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), this.options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD));
        }
        return new VCFWriter(file, outputStream, this.refDict, this.idxCreator, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), this.options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), this.options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD));
    }

    private VariantContextWriter createBCFWriter(File file, OutputStream outputStream) {
        if (this.idxCreator == null) {
            return new BCF2Writer(file, outputStream, this.refDict, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
        }
        return new BCF2Writer(file, outputStream, this.refDict, this.idxCreator, this.options.contains((Object)Options.INDEX_ON_THE_FLY), this.options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
    }

    public static enum OutputType {
        UNSPECIFIED,
        VCF,
        BCF,
        BLOCK_COMPRESSED_VCF,
        VCF_STREAM,
        BCF_STREAM;

    }
}

