/*
 * Decompiled with CFR 0.152.
 */
package com.excella.gradle.cucumber;

import com.excella.gradle.cucumber.AsYouGoFormatter;
import cucumber.api.cli.Main;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberRunner {
    static final Logger LOGGER = LoggerFactory.getLogger(CucumberRunner.class);

    public void runCucumberTests(List<String> glueDirs, List<String> tags, List<String> formats, boolean strict, boolean monochrome, boolean dryRun, List<String> featureDirs) throws Throwable {
        ArrayList<String> args = new ArrayList<String>();
        if (formats != null) {
            for (String format : formats) {
                args.add("--format");
                if ("asyougo".equals(format)) {
                    format = AsYouGoFormatter.class.getName();
                }
                args.add(format);
            }
        }
        if (glueDirs != null) {
            for (String dir : glueDirs) {
                args.add("--glue");
                args.add(dir);
            }
        }
        if (tags != null) {
            args.add("--tags");
            for (String tag : tags) {
                args.add(tag);
            }
        }
        if (strict) {
            args.add("--strict");
        }
        if (monochrome) {
            args.add("--monochrome");
        }
        if (dryRun) {
            args.add("--dry-run");
        }
        if (featureDirs != null) {
            for (String dir : featureDirs) {
                args.add(dir);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            this.logParameters(args);
        }
        Main.main((String[])args.toArray(new String[args.size()]));
    }

    private void logParameters(List<String> args) {
        URL[] urls;
        LOGGER.debug("Cucumber runner args: ");
        for (String arg : args) {
            LOGGER.debug(arg + ", ");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Cucumber class path entries: ");
        for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
            LOGGER.debug(url.getFile());
        }
    }
}

