/*
 * Decompiled with CFR 0.152.
 */
package org.thavam.util.concurrent.blockingMap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.thavam.util.concurrent.blockingMap.BlockingMap;
import org.thavam.util.concurrent.blockingMap.ObjectLatch;

class ActiveBlockingHashMap<K, V>
implements BlockingMap<K, V> {
    private final ConcurrentMap<K, ObjectLatch<V>> primaryMap;
    private final Map<Thread, ObjectLatch<V>> blockedThreadsMap;
    private final ReadWriteLock primaryMapLock = new ReentrantReadWriteLock();
    private final Lock primaryMapReadLock = this.primaryMapLock.readLock();
    private final Lock primaryMapWriteLock = this.primaryMapLock.writeLock();
    private final AtomicBoolean cleared = new AtomicBoolean(false);

    ActiveBlockingHashMap() {
        this.primaryMap = new ConcurrentHashMap<K, ObjectLatch<V>>();
        this.blockedThreadsMap = new ConcurrentHashMap<Thread, ObjectLatch<V>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyAvailable(K key) {
        this.primaryMapReadLock.lock();
        try {
            ObjectLatch latch = (ObjectLatch)this.primaryMap.get(key);
            boolean bl = latch != null && latch.isAvailable();
            return bl;
        }
        finally {
            this.primaryMapReadLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.isKeyAvailable(key);
    }

    @Override
    public V get(Object key) {
        V result = null;
        ObjectLatch latch = (ObjectLatch)this.primaryMap.get(key);
        if (latch != null) {
            try {
                result = (V)latch.getImmediately();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ActiveBlockingHashMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        ObjectLatch latch = (ObjectLatch)this.primaryMap.get(key);
        if (latch == null) {
            this.primaryMap.putIfAbsent(key, new ObjectLatch());
            latch = (ObjectLatch)this.primaryMap.get(key);
        }
        return latch.set(value);
    }

    @Override
    public V remove(Object key) {
        V result = null;
        try {
            result = this.take(key, Integer.MIN_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ActiveBlockingHashMap.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    @Override
    public V offer(K key, V value) {
        return this.put(key, value);
    }

    @Override
    public V take(K key) throws InterruptedException {
        return this.take(key, Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    @Override
    public V offer(K key, V value, long timeout, TimeUnit unit) {
        return this.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V take(K key, long timeout, TimeUnit unit) throws InterruptedException {
        V result = null;
        if (!this.cleared.get()) {
            this.primaryMapWriteLock.lock();
            ObjectLatch latch = null;
            try {
                latch = (ObjectLatch)this.primaryMap.get(key);
                if (latch == null) {
                    this.primaryMap.putIfAbsent(key, new ObjectLatch());
                    latch = (ObjectLatch)this.primaryMap.get(key);
                }
            }
            finally {
                this.primaryMapWriteLock.unlock();
            }
            this.blockedThreadsMap.put(Thread.currentThread(), latch);
            result = (V)latch.get(timeout, unit);
            this.blockedThreadsMap.remove(Thread.currentThread());
            this.primaryMapWriteLock.lock();
            try {
                result = this.primaryMap.remove(key) == null ? null : result;
            }
            finally {
                this.primaryMapWriteLock.unlock();
            }
        }
        return result;
    }

    @Override
    public void clear() {
        if (!this.cleared.getAndSet(true)) {
            this.primaryMapWriteLock.lock();
            try {
                for (Thread thread : this.blockedThreadsMap.keySet()) {
                    thread.interrupt();
                }
                this.primaryMap.clear();
            }
            finally {
                this.primaryMapWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.primaryMapReadLock.lock();
        try {
            for (ObjectLatch latch : this.primaryMap.values()) {
                if (!latch.isAvailable() || latch.getImmediately() == null || !latch.getImmediately().equals(value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.primaryMapReadLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.primaryMapReadLock.lock();
        try {
            for (ObjectLatch latch : this.primaryMap.values()) {
                if (!latch.isAvailable()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.primaryMapReadLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        this.primaryMapReadLock.lock();
        try {
            for (ObjectLatch latch : this.primaryMap.values()) {
                if (!latch.isAvailable()) continue;
                ++size;
            }
        }
        finally {
            this.primaryMapReadLock.unlock();
        }
        return size;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }
}

