/*
 * Decompiled with CFR 0.152.
 */
package org.thavam.util.concurrent.blockingMap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.thavam.util.concurrent.blockingMap.ActiveBlockingHashMap;
import org.thavam.util.concurrent.blockingMap.BlockingMap;
import org.thavam.util.concurrent.blockingMap.PassiveHashMap;

public class BlockingHashMap<K, V>
implements BlockingMap<K, V> {
    private volatile BlockingMap<K, V> state;
    private final AtomicBoolean cleared = new AtomicBoolean(false);

    public BlockingHashMap() {
        this.state = new ActiveBlockingHashMap();
    }

    @Override
    public boolean isKeyAvailable(K key) {
        return this.state.isKeyAvailable(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.state.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.state.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.state.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.state.remove(key);
    }

    @Override
    public V offer(K key, V value) throws InterruptedException {
        return this.state.offer(key, value);
    }

    @Override
    public V take(K key) throws InterruptedException {
        return this.state.take(key);
    }

    @Override
    public V offer(K key, V value, long timeout, TimeUnit unit) throws InterruptedException {
        return this.state.offer(key, value, timeout, unit);
    }

    @Override
    public V take(K key, long timeout, TimeUnit unit) throws InterruptedException {
        return this.state.take(key, timeout, unit);
    }

    @Override
    public void clear() {
        if (!this.cleared.getAndSet(true)) {
            BlockingMap<K, V> oldState = this.state;
            this.state = PassiveHashMap.getInstance();
            oldState.clear();
        } else {
            this.state.clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return this.state.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    @Override
    public int size() {
        return this.state.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.state.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.state.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.state.values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.state.putAll(m);
    }
}

