/*
 * Decompiled with CFR 0.152.
 */
package org.thavam.util.concurrent.blockingMap;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ObjectLatch<R> {
    private volatile R object = null;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ReadWriteLock setLock = new ReentrantReadWriteLock();

    ObjectLatch() {
    }

    public boolean isAvailable() {
        this.setLock.readLock().lock();
        try {
            boolean bl = this.latch.getCount() == 0L;
            return bl;
        }
        finally {
            this.setLock.readLock().unlock();
        }
    }

    public R set(R object) {
        this.setLock.writeLock().lock();
        try {
            if (!this.isAvailable()) {
                this.object = object;
                this.latch.countDown();
                R r = null;
                return r;
            }
            R r = this.object;
            return r;
        }
        finally {
            this.setLock.writeLock().unlock();
        }
    }

    public R getImmediately() throws InterruptedException {
        boolean available = this.latch.await(Integer.MIN_VALUE, TimeUnit.NANOSECONDS);
        return available ? (R)this.object : null;
    }

    public R get() throws InterruptedException {
        this.latch.await(Integer.MAX_VALUE, TimeUnit.DAYS);
        return this.object;
    }

    public R get(long time, TimeUnit unit) throws InterruptedException {
        this.latch.await(time, unit);
        return this.object;
    }
}

