/*
 * Decompiled with CFR 0.152.
 */
package org.thavam.util.concurrent.blockingMapTester;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.thavam.util.concurrent.blockingMap.BlockingHashMap;
import org.thavam.util.concurrent.blockingMap.BlockingMap;

public class BlockingMapTester {
    private final Map<Integer, String> referenceMap;
    private final BlockingMap<Integer, String> blockingMap;
    private final Queue<String> productionErrors = new ConcurrentLinkedQueue<String>();
    private final Queue<Map.Entry<Integer, String>> comsumptionErrors = new ConcurrentLinkedQueue<Map.Entry<Integer, String>>();
    private List<Callable<Map.Entry<Integer, String>>> consumers;
    private List<Callable<String>> producers;
    private final ExecutorService executor;
    int i = 0;
    int j = 0;

    public BlockingMapTester() {
        this.referenceMap = new ConcurrentHashMap<Integer, String>();
        while (this.i < 100) {
            this.referenceMap.put(this.i, "Stringy " + this.i);
            ++this.i;
        }
        this.blockingMap = new BlockingHashMap<Integer, String>();
        this.executor = Executors.newCachedThreadPool();
    }

    void createConsumers() {
        this.consumers = new ArrayList<Callable<Map.Entry<Integer, String>>>();
        this.i = 0;
        while (this.i < 100) {
            this.consumers.add(new Callable<Map.Entry<Integer, String>>(){
                final int key;
                {
                    this.key = BlockingMapTester.this.i;
                }

                @Override
                public Map.Entry<Integer, String> call() {
                    Map.Entry<Integer, String> entry = null;
                    try {
                        final String valueString = (String)BlockingMapTester.this.blockingMap.take(this.key);
                        System.out.println("blockingmap.take(" + this.key + ") = " + valueString);
                        entry = new Map.Entry<Integer, String>(){
                            final Integer entryKey;
                            final String value;
                            {
                                this.entryKey = key;
                                this.value = valueString;
                            }

                            @Override
                            public Integer getKey() {
                                return this.entryKey;
                            }

                            @Override
                            public String getValue() {
                                return this.value;
                            }

                            @Override
                            public String setValue(String value) {
                                throw new UnsupportedOperationException("Not supported yet.");
                            }

                            public String toString() {
                                return "key,value : " + this.entryKey + ":" + this.value;
                            }
                        };
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return entry;
                }
            });
            ++this.i;
        }
    }

    void startConsuming() {
        this.executor.submit(new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    List products = BlockingMapTester.this.executor.invokeAll(BlockingMapTester.this.consumers);
                    for (Future product : products) {
                        Map.Entry returnedEntry = (Map.Entry)product.get();
                        if (((String)returnedEntry.getValue()).equals(BlockingMapTester.this.referenceMap.get(returnedEntry.getKey()))) continue;
                        BlockingMapTester.this.comsumptionErrors.add(returnedEntry);
                    }
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        }));
    }

    void createProducers() {
        this.producers = new ArrayList<Callable<String>>();
        this.j = 0;
        while (this.j < 100) {
            this.producers.add(new Callable<String>(){
                final int key;
                {
                    this.key = BlockingMapTester.this.j;
                }

                @Override
                public String call() {
                    return (String)BlockingMapTester.this.blockingMap.put(this.key, BlockingMapTester.this.referenceMap.get(this.key));
                }
            });
            ++this.j;
        }
    }

    void startProducing() {
        this.executor.submit(new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    List productionAcks = BlockingMapTester.this.executor.invokeAll(BlockingMapTester.this.producers);
                    for (Future productionAck : productionAcks) {
                        String ack = (String)productionAck.get();
                        if (ack == null) continue;
                        BlockingMapTester.this.productionErrors.add(ack);
                    }
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        }));
    }

    void checkForConsumptionErrors() {
        Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, "errors found : {0}", this.comsumptionErrors);
    }

    void checkForProductionErrors() {
        Logger.getLogger(BlockingMapTester.class.getName()).log(Level.SEVERE, "errors found : {0}", this.productionErrors);
    }

    String getErrorDescription(Queue<Map.Entry<Integer, String>> error) {
        Map.Entry<Integer, String> errorEntry;
        StringBuilder errorMsg = new StringBuilder();
        while ((errorEntry = error.poll()) != null) {
            errorMsg.append(errorEntry.toString());
        }
        return errorMsg.toString();
    }

    void shutDownSynchronizer() {
        this.blockingMap.clear();
    }

    public static void main(String[] ar) throws InterruptedException {
        BlockingMapTester tester = new BlockingMapTester();
        tester.createConsumers();
        tester.startConsuming();
        tester.createProducers();
        tester.startProducing();
        Thread.sleep(10000L);
        tester.checkForProductionErrors();
        tester.checkForConsumptionErrors();
        tester.shutDownSynchronizer();
    }
}

