/*
 * Decompiled with CFR 0.152.
 */
package org.thavam.util.concurrent.blockingMapTester;

import org.thavam.util.concurrent.blockingMap.BlockingHashMap;
import org.thavam.util.concurrent.blockingMap.BlockingMap;

public class SimpleTester {
    public static final String CONSUMER_1 = "consumer-1";
    public static final String CONSUMER_2 = "consumer-2";
    public static final String PRODUCER_1 = "producer-1";
    public static final String PRODUCER_2 = "producer-2";
    static volatile BlockingMap<Integer, String> blockingMap = new BlockingHashMap<Integer, String>();
    boolean suspend = false;
    final SimpleTester blockingMapTester = this;
    static Thread consumer;
    static Thread consumer2;
    static Thread producer1;
    static Thread producer2;

    static void print(String msg) {
        System.out.println(Thread.currentThread().getName() + " : " + msg);
    }

    public static void main(String[] ar) {
        consumer = new Thread(CONSUMER_1){

            @Override
            public void run() {
                String value = null;
                try {
                    value = blockingMap.take(new Integer(1));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SimpleTester.print("blockingMap.get(new Integer(1)) = " + value);
            }
        };
        consumer2 = new Thread(CONSUMER_2){

            @Override
            public void run() {
                String value = null;
                try {
                    value = blockingMap.take(new Integer(2));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SimpleTester.print("blockingMap.get(new Integer(2)) = " + value);
            }
        };
        producer1 = new Thread(PRODUCER_1){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    blockingMap.put(new Integer(2), "two");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        producer2 = new Thread(PRODUCER_2){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    blockingMap.put(new Integer(1), "one");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        consumer.start();
        consumer2.start();
        producer1.start();
        producer2.start();
        try {
            Thread.sleep(20000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        blockingMap.clear();
        blockingMap.clear();
    }
}

