/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.V4L4JDataBuffer;
import au.edu.jcu.v4l4j.V4L4JRaster;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;

class BaseVideoFrame
implements VideoFrame {
    protected int frameLength;
    protected AbstractGrabber frameGrabber;
    protected byte[] frameBuffer;
    protected long sequenceNumber;
    protected long captureTime;
    protected int bufferIndex;
    protected V4L4JDataBuffer dataBuffer;
    protected boolean recycled;
    protected V4L4JRaster raster;
    protected BufferedImage bufferedImage;

    protected BaseVideoFrame(AbstractGrabber grabber, int bufferSize) {
        this.frameGrabber = grabber;
        this.frameBuffer = new byte[bufferSize];
        this.dataBuffer = new V4L4JDataBuffer(this.frameBuffer);
        this.raster = null;
        this.bufferedImage = null;
        this.bufferIndex = 0;
        this.recycled = true;
    }

    final synchronized void prepareForDelivery(int length, int index, long sequence, long timeUs) {
        this.frameLength = length;
        this.dataBuffer.setNewFrameSize(length);
        this.sequenceNumber = sequence;
        this.captureTime = timeUs;
        this.bufferIndex = index;
        this.recycled = false;
    }

    final synchronized void waitTillRecycled() throws InterruptedException {
        while (!this.recycled) {
            this.wait();
        }
    }

    final byte[] getByteArray() {
        return this.frameBuffer;
    }

    final int getBufferInex() {
        return this.bufferIndex;
    }

    protected WritableRaster refreshRaster() {
        if (this.raster == null) {
            throw new UnsupportedMethod("A raster can not be generated for this image format (" + this.frameGrabber.getImageFormat().toString() + ")");
        }
        return this.raster;
    }

    protected BufferedImage refreshBufferedImage() {
        if (this.bufferedImage == null) {
            throw new UnsupportedMethod("A Bufferedimage can not be generated for this image format (" + this.frameGrabber.getImageFormat().toString() + ")");
        }
        return this.bufferedImage;
    }

    private final void checkIfRecycled() throws StateException {
        if (this.recycled) {
            throw new StateException("This video frame has been recycled");
        }
    }

    @Override
    public final FrameGrabber getFrameGrabber() {
        return this.frameGrabber;
    }

    @Override
    public final synchronized int getFrameLength() {
        this.checkIfRecycled();
        return this.frameLength;
    }

    @Override
    public final synchronized byte[] getBytes() {
        this.checkIfRecycled();
        return this.frameBuffer;
    }

    @Override
    public final synchronized DataBuffer getDataBuffer() {
        this.checkIfRecycled();
        return this.dataBuffer;
    }

    @Override
    public final synchronized WritableRaster getRaster() {
        this.checkIfRecycled();
        return this.refreshRaster();
    }

    @Override
    public final synchronized BufferedImage getBufferedImage() {
        this.checkIfRecycled();
        return this.refreshBufferedImage();
    }

    @Override
    public final synchronized long getSequenceNumber() {
        this.checkIfRecycled();
        return this.sequenceNumber;
    }

    @Override
    public final synchronized long getCaptureTime() {
        this.checkIfRecycled();
        return this.captureTime;
    }

    @Override
    public final synchronized void recycle() {
        if (!this.recycled) {
            this.frameGrabber.recycleVideoBuffer(this);
            this.recycled = true;
            this.notifyAll();
        }
    }
}

