/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.exceptions.StateException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ControlList {
    private Hashtable<String, Control> controls;
    private boolean released;

    ControlList(Hashtable<String, Control> c) {
        this.controls = c;
        this.released = false;
    }

    ControlList(Control[] c) {
        this.controls = new Hashtable();
        for (Control ctrl : c) {
            this.controls.put(ctrl.getName(), ctrl);
        }
        this.released = false;
    }

    public synchronized Hashtable<String, Control> getTable() {
        this.checkReleased();
        return new Hashtable<String, Control>(this.controls);
    }

    public synchronized List<Control> getList() {
        this.checkReleased();
        return new Vector<Control>(this.controls.values());
    }

    public synchronized Control getControl(String n) {
        this.checkReleased();
        return this.controls.get(n);
    }

    synchronized void release() {
        this.released = true;
        for (Control c : this.controls.values()) {
            c.release();
        }
    }

    private void checkReleased() {
        if (this.released) {
            throw new StateException("The control list has been released and must not be used");
        }
    }
}

