/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.ImageFormatList;
import au.edu.jcu.v4l4j.InputInfo;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.util.List;
import java.util.Vector;

public class DeviceInfo {
    private String name;
    private String deviceFile;
    private List<InputInfo> inputs = new Vector<InputInfo>();
    private ImageFormatList formats;
    private long object;
    private boolean released;

    private native void getInfo(long var1);

    private native void doRelease(long var1);

    private native FrameInterval doListIntervals(long var1, int var3, int var4, int var5);

    public synchronized String getName() {
        this.checkRelease();
        return this.name;
    }

    public synchronized String getDeviceFile() {
        this.checkRelease();
        return this.deviceFile;
    }

    public synchronized List<InputInfo> getInputs() {
        this.checkRelease();
        return new Vector<InputInfo>(this.inputs);
    }

    public synchronized ImageFormatList getFormatList() {
        this.checkRelease();
        return this.formats;
    }

    public synchronized FrameInterval listIntervals(ImageFormat imf, int width, int height) {
        this.checkRelease();
        return this.doListIntervals(this.object, imf.getIndex(), width, height);
    }

    DeviceInfo(long object, String dev) throws V4L4JException {
        this.deviceFile = dev;
        this.getInfo(object);
        this.object = object;
    }

    synchronized void release() {
        this.doRelease(this.object);
    }

    private void checkRelease() throws StateException {
        if (this.released) {
            throw new StateException("The video device object has been released");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deviceFile == null ? 0 : this.deviceFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)obj;
        return !(this.deviceFile == null ? other.deviceFile != null : !this.deviceFile.equals(other.deviceFile));
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cant load v4l4j JNI library");
            throw e;
        }
    }
}

