/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.TunerInfo;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import java.util.HashSet;
import java.util.Set;

public class InputInfo {
    private String name;
    private short type;
    private Set<Integer> supportedStandards;
    private TunerInfo tuner;
    private int index;

    private InputInfo(String n, int[] stds, short t, TunerInfo tun, int id) {
        this.tuner = tun;
        this.supportedStandards = new HashSet<Integer>();
        for (int s : stds) {
            this.supportedStandards.add(new Integer(s));
        }
        this.type = t;
        this.name = n;
        this.index = id;
    }

    InputInfo(String n, int[] stds, TunerInfo tun, int id) {
        this(n, stds, 1, tun, id);
    }

    InputInfo(String n, int[] stds, int id) {
        this(n, stds, 2, null, id);
    }

    public String getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public Set<Integer> getSupportedStandards() {
        return this.supportedStandards;
    }

    public TunerInfo getTunerInfo() throws NoTunerException {
        if (this.tuner == null) {
            throw new NoTunerException("No tuner connected to this input");
        }
        return this.tuner;
    }

    public boolean hasTuner() {
        return this.tuner != null;
    }

    public int getIndex() {
        return this.index;
    }
}

