/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.CaptureCallback;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.util.concurrent.ThreadFactory;

class PushSource
implements Runnable {
    private CaptureCallback callback;
    private AbstractGrabber frameGrabber;
    private Thread thread;
    private ThreadFactory threadFactory;
    private int state;
    private static final int STATE_STOPPED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_ABOUT_TO_STOP = 2;

    public PushSource(AbstractGrabber grabber, CaptureCallback callback, ThreadFactory factory) {
        if (grabber == null || callback == null) {
            throw new NullPointerException("the frame grabber and callback cannot be null");
        }
        this.callback = callback;
        this.frameGrabber = grabber;
        this.threadFactory = factory;
        this.state = 0;
    }

    public final synchronized long startCapture() throws V4L4JException {
        if (this.state != 0) {
            throw new StateException("The capture has already been started");
        }
        this.state = 1;
        this.thread = this.threadFactory.newThread(this);
        this.thread.setName(this.thread.getName() + " - v4l4j push source");
        this.thread.start();
        return this.thread.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopCapture() {
        PushSource pushSource = this;
        synchronized (pushSource) {
            if (this.state == 0 || this.state == 2) {
                return;
            }
            this.state = 2;
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            if (!Thread.currentThread().equals(this.thread)) {
                while (this.state == 2) {
                    try {
                        this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public final void run() {
        VideoFrame frame = null;
        while (!Thread.interrupted()) {
            try {
                frame = this.frameGrabber.getNextVideoFrame();
                try {
                    this.callback.nextFrame(frame);
                }
                catch (Throwable t) {
                }
            }
            catch (Throwable t) {
                try {
                    if (this.frameGrabber.isStarted()) {
                        this.callback.exceptionReceived(new V4L4JException("Exception received while grabbing next frame", t));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Thread.currentThread().interrupt();
            }
        }
        this.state = 0;
    }
}

