/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.util.List;
import java.util.Vector;

public class ResolutionInfo {
    private final Type type;
    private StepwiseResolution stepwiseObject;
    private List<DiscreteResolution> discreteValues;

    private native int doGetType(int var1, long var2);

    private native void doGetStepwise(int var1, long var2);

    private native void doGetDiscrete(int var1, long var2);

    ResolutionInfo(int index, long o) {
        int t;
        try {
            t = this.doGetType(index, o);
            if (t == 1) {
                this.discreteValues = new Vector<DiscreteResolution>();
                this.doGetDiscrete(index, o);
            } else if (t == 2) {
                this.doGetStepwise(index, o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("There was an error checking the supported resolutions.\nPlease report this error to thev4l4j mailing list.\nSee REAME file for information on reporting bugs");
            this.type = Type.UNSUPPORTED;
            return;
        }
        this.type = t == 0 ? Type.UNSUPPORTED : (t == 1 ? Type.DISCRETE : Type.STEPWISE);
    }

    public Type getType() {
        return this.type;
    }

    public List<DiscreteResolution> getDiscreteResolutions() throws UnsupportedMethod {
        if (this.type != Type.DISCRETE) {
            throw new UnsupportedMethod("Supported resolutions are not discrete");
        }
        return new Vector<DiscreteResolution>(this.discreteValues);
    }

    public StepwiseResolution getStepwiseResolution() throws UnsupportedMethod {
        if (this.type != Type.STEPWISE) {
            throw new UnsupportedMethod("Supported resolutions are not stepwsie");
        }
        return this.stepwiseObject;
    }

    public String toString() {
        String s;
        if (this.type == Type.STEPWISE) {
            s = this.stepwiseObject.toString();
        } else if (this.type == Type.DISCRETE) {
            s = "";
            for (DiscreteResolution d : this.discreteValues) {
                s = s + d + " - ";
            }
        } else {
            s = "no resolution information";
        }
        return s;
    }

    public static class StepwiseResolution {
        public final int minWidth;
        public final int maxWidth;
        public final int stepWidth;
        public final int minHeight;
        public final int maxHeight;
        public final int stepHeight;
        public final FrameInterval minInterval;
        public final FrameInterval maxInterval;

        StepwiseResolution(int minw, int minh, int maxw, int maxh, int stepw, int steph, FrameInterval minI, FrameInterval maxI) {
            this.minWidth = minw;
            this.maxWidth = maxw;
            this.stepWidth = stepw;
            this.minHeight = minh;
            this.maxHeight = maxh;
            this.stepHeight = steph;
            this.minInterval = minI;
            this.maxInterval = maxI;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getWidthStep() {
            return this.stepWidth;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public int getHeightStep() {
            return this.stepHeight;
        }

        public FrameInterval getMinResFrameInterval() {
            return this.minInterval;
        }

        public FrameInterval getMaxResFrameInterval() {
            return this.maxInterval;
        }

        public String toString() {
            return "min: " + this.minWidth + "x" + this.minHeight + " (" + this.minInterval + ") - max: " + this.maxWidth + "x" + this.maxHeight + " (" + this.maxInterval + ") - step: " + this.stepWidth + "x" + this.stepHeight + ")\n";
        }
    }

    public static class DiscreteResolution {
        public final int width;
        public final int height;
        public final FrameInterval interval;

        private DiscreteResolution(int w, int h, FrameInterval f) {
            this.width = w;
            this.height = h;
            this.interval = f;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public FrameInterval getFrameInterval() {
            return this.interval;
        }

        public String toString() {
            return this.width + "x" + this.height + " (" + this.interval + ")";
        }
    }

    public static enum Type {
        UNSUPPORTED,
        DISCRETE,
        STEPWISE;

    }
}

