/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.exceptions.StateException;
import java.util.List;
import java.util.Vector;

public class TunerList {
    private Vector<Tuner> tuners;
    private boolean released;

    TunerList(List<Tuner> t) {
        this.tuners = new Vector<Tuner>(t);
        this.released = false;
    }

    public synchronized List<Tuner> getList() {
        this.checkReleased();
        return new Vector<Tuner>(this.tuners);
    }

    public synchronized Tuner getTuner(int i) {
        this.checkReleased();
        for (Tuner t : this.tuners) {
            if (t.getIndex() != i) continue;
            return t;
        }
        throw new ArrayIndexOutOfBoundsException("No tuner with such index");
    }

    synchronized void release() {
        this.released = true;
        for (Tuner t : this.tuners) {
            t.release();
        }
    }

    private void checkReleased() {
        if (this.released) {
            throw new StateException("The tuner list has been released and must not be used");
        }
    }
}

