/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.UncompressedVideoFrame;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.util.concurrent.ThreadFactory;

public class YUVFrameGrabber
extends AbstractGrabber {
    YUVFrameGrabber(DeviceInfo di, long o, int w, int h, int ch, int std, Tuner t, ImageFormat imf, ThreadFactory factory) throws ImageFormatException {
        super(di, o, w, h, ch, std, t, imf, 4, factory);
    }

    @Override
    void init() throws V4L4JException {
        try {
            super.init();
        }
        catch (ImageFormatException ife) {
            if (this.format == -1) {
                String msg = "v4l4j was unable to find image format supported by the \nvideo device and that can be converted to YUV420.\nPlease let the author know about this, so that support\nfor this video device can be improved. See \nREADME file on how to submit v4l4j reports.";
                System.err.println(msg);
                ife = new ImageFormatException(msg);
            }
            throw ife;
        }
    }

    @Override
    public ImageFormat getImageFormat() {
        this.state.checkReleased();
        return this.dInfo.getFormatList().getYUVEncodableFormat(this.format);
    }

    @Override
    protected void createBuffers(int bufferSize) {
        int numberOfBuffers = this.nbV4LBuffers;
        while (numberOfBuffers-- > 0) {
            this.videoFrames.add(new UncompressedVideoFrame(this, bufferSize, null, null));
        }
    }
}

