/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamDriverUtils;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamListener;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Webcam {
    private static final Logger LOG = LoggerFactory.getLogger(Webcam.class);
    private static final List<String> DRIVERS_LIST = new ArrayList<String>(Arrays.asList("com.github.sarxos.webcam.ds.openimaj.OpenImajDriver", "com.github.sarxos.webcam.ds.civil.LtiCivilDriver", "com.github.sarxos.webcam.ds.jmf.JmfDriver", "com.github.sarxos.webcam.ds.buildin.DefaultDriver"));
    private static WebcamDriver driver = null;
    private static List<Webcam> webcams = null;
    private List<WebcamListener> listeners = new ArrayList<WebcamListener>();
    private ShutdownHook hook = null;
    private WebcamDevice device = null;
    private boolean open = false;

    public Webcam(WebcamDevice device) {
        this.device = device;
    }

    public synchronized void open() {
        if (this.open) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Opening webcam " + this.getName());
        }
        if (this.device.getSize() == null) {
            this.device.setSize(this.device.getSizes()[0]);
        }
        this.device.open();
        this.open = true;
        this.hook = new ShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.hook);
        WebcamEvent we = new WebcamEvent(this);
        for (WebcamListener l : this.listeners) {
            try {
                l.webcamOpen(we);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void close() {
        if (!this.open) {
            return;
        }
        Runtime.getRuntime().removeShutdownHook(this.hook);
        this.close0();
    }

    private void close0() {
        if (!this.open) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Cosing webcam " + this.getName());
        }
        this.device.close();
        this.open = false;
        WebcamEvent we = new WebcamEvent(this);
        for (WebcamListener l : this.listeners) {
            try {
                l.webcamClosed(we);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public Dimension getViewSize() {
        return this.device.getSize();
    }

    public Dimension[] getViewSizes() {
        return this.device.getSizes();
    }

    public void setViewSize(Dimension size) {
        Dimension[] sizes;
        boolean ok = false;
        for (Dimension d : sizes = this.getViewSizes()) {
            if (d.width != size.width || d.height != size.height) continue;
            ok = true;
            break;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Incorrect dimension [");
            sb.append(size.width).append("x").append(size.height).append("] ");
            sb.append("possible ones are ");
            for (Dimension d : sizes) {
                sb.append("[").append(d.width).append("x").append(d.height).append("] ");
            }
            throw new IllegalArgumentException(sb.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting new view size " + size);
        }
        this.device.setSize(size);
    }

    public synchronized BufferedImage getImage() {
        if (!this.open) {
            this.open();
        }
        return this.device.getImage();
    }

    public static List<Webcam> getWebcams() {
        if (webcams == null) {
            webcams = new ArrayList<Webcam>();
            if (driver == null) {
                driver = WebcamDriverUtils.findDriver(DRIVERS_LIST);
            }
            for (WebcamDevice device : driver.getDevices()) {
                Webcam webcam = new Webcam(device);
                webcams.add(webcam);
            }
            if (LOG.isInfoEnabled()) {
                for (Webcam webcam : webcams) {
                    LOG.info("Webcam found " + webcam.getName());
                }
            }
        }
        return webcams;
    }

    public static Webcam getDefault() {
        List<Webcam> webcams = Webcam.getWebcams();
        if (webcams.isEmpty()) {
            throw new WebcamException("No webcam available in the system");
        }
        return webcams.get(0);
    }

    public String getName() {
        return this.device.getName();
    }

    public String toString() {
        return "webcam:" + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebcamListener(WebcamListener l) {
        List<WebcamListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebcamListener[] getWebcamListeners() {
        List<WebcamListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new WebcamListener[this.listeners.size()]);
        }
    }

    public static WebcamDriver getDriver() {
        return driver;
    }

    public static void setDriver(WebcamDriver driver) {
        Webcam.driver = driver;
    }

    public static void setDriver(Class<? extends WebcamDriver> driverClass) {
        WebcamDriver driver = null;
        try {
            driver = driverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new WebcamException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebcamException(e);
        }
        Webcam.driver = driver;
    }

    public static void registerDriver(Class<? extends WebcamDriver> clazz) {
        Webcam.registerDriver(clazz.getCanonicalName());
    }

    public static void registerDriver(String clazzName) {
        DRIVERS_LIST.add(clazzName);
    }

    private static class ShutdownHook
    extends Thread {
        private Webcam webcam = null;

        public ShutdownHook(Webcam webcam) {
            this.webcam = webcam;
        }

        @Override
        public void run() {
            LOG.info("Automatic webcam resource deallocation");
            super.run();
            this.webcam.close0();
        }
    }
}

