/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class WebcamPanel
extends JPanel
implements WebcamListener {
    private static final long serialVersionUID = 5792962512394656227L;
    private int frequency = 65;
    private Webcam webcam = null;
    private BufferedImage image = null;
    private Repainter repainter = null;
    private volatile boolean paused = false;

    public WebcamPanel(Webcam webcam) {
        this.webcam = webcam;
        this.webcam.addWebcamListener(this);
        this.repainter = new Repainter();
        if (!webcam.isOpen()) {
            webcam.open();
        }
        this.setPreferredSize(webcam.getViewSize());
        this.repainter.start();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, 0, 0, null);
    }

    @Override
    public void webcamOpen(WebcamEvent we) {
        if (this.repainter == null) {
            this.repainter = new Repainter();
        }
        this.repainter.start();
        this.setPreferredSize(this.webcam.getViewSize());
    }

    @Override
    public void webcamClosed(WebcamEvent we) {
        try {
            this.repainter.join();
            this.repainter = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        System.out.println("paused");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (!this.paused) {
            return;
        }
        Repainter repainter = this.repainter;
        synchronized (repainter) {
            this.repainter.notifyAll();
        }
        this.paused = false;
        System.out.println("resumed");
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        if (frequency > 100) {
            frequency = 100;
        }
        if (frequency < 1) {
            frequency = 1;
        }
        this.frequency = frequency;
    }

    private class Repainter
    extends Thread {
        public Repainter() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            while (WebcamPanel.this.webcam.isOpen()) {
                WebcamPanel.this.image = WebcamPanel.this.webcam.getImage();
                try {
                    if (WebcamPanel.this.paused) {
                        Repainter repainter = this;
                        synchronized (repainter) {
                            this.wait();
                        }
                    }
                    Thread.sleep(1000 / WebcamPanel.this.frequency);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                WebcamPanel.this.repaint();
            }
        }
    }
}

