/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDriverUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDriverUtils.class);

    private WebcamDriverUtils() {
    }

    protected static WebcamDriver findDriver(List<String> drivers) {
        for (String name : drivers) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Searching driver: " + name);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            LOG.info("Webcam driver has been found: " + name);
            try {
                return (WebcamDriver)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        LOG.error("Webcam driver has not been found! Please add one to the classpath!");
        throw new WebcamException("No webcam driver available");
    }

    protected static Class<?>[] getClasses(String pkgname, boolean flat) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList classes = new ArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = pkgname.replace('.', '/');
        Enumeration<URL> resources = null;
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read path " + path, e);
        }
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        for (File directory : dirs) {
            try {
                classes.addAll(WebcamDriverUtils.findClasses(directory, pkgname, flat));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found", e);
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File dir, String pkgname, boolean flat) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!dir.exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory() && !flat) {
                classes.addAll(WebcamDriverUtils.findClasses(file, pkgname + "." + file.getName(), flat));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(pkgname + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

