/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamListener;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamPanel
extends JPanel
implements WebcamListener {
    private static final long serialVersionUID = 5792962512394656227L;
    private static final Logger LOG = LoggerFactory.getLogger(WebcamPanel.class);
    private double frequency = 65.0;
    private Webcam webcam = null;
    private BufferedImage image = null;
    private Repainter repainter = null;
    private volatile boolean paused = false;
    private static final double MIN_FREQUENCY = 0.016;
    private static final double MAX_FREQUENCY = 25.0;

    public WebcamPanel(Webcam webcam) {
        this.webcam = webcam;
        this.webcam.addWebcamListener(this);
        if (!webcam.isOpen()) {
            webcam.open();
        }
        this.setPreferredSize(webcam.getViewSize());
        if (this.repainter == null) {
            this.repainter = new Repainter();
            this.repainter.start();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, 0, 0, null);
    }

    @Override
    public void webcamOpen(WebcamEvent we) {
        if (this.repainter == null) {
            this.repainter = new Repainter();
            this.repainter.start();
        }
        this.setPreferredSize(this.webcam.getViewSize());
    }

    @Override
    public void webcamClosed(WebcamEvent we) {
        if (this.repainter != null) {
            if (this.repainter.isAlive()) {
                try {
                    this.repainter.join(1000L);
                }
                catch (InterruptedException e) {
                    throw new WebcamException("Thread interrupted", e);
                }
            }
            this.repainter = null;
        }
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (!this.paused) {
            return;
        }
        Repainter repainter = this.repainter;
        synchronized (repainter) {
            this.repainter.notifyAll();
        }
        this.paused = false;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFPS(double frequency) {
        if (frequency > 25.0) {
            frequency = 25.0;
        }
        if (frequency < 0.016) {
            frequency = 0.016;
        }
        this.frequency = frequency;
    }

    private class Repainter
    extends Thread {
        public Repainter() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            while (WebcamPanel.this.webcam.isOpen()) {
                WebcamPanel.this.image = WebcamPanel.this.webcam.getImage();
                if (WebcamPanel.this.image == null) {
                    LOG.error("Image is null");
                }
                try {
                    if (WebcamPanel.this.paused) {
                        Repainter repainter = this;
                        synchronized (repainter) {
                            this.wait();
                        }
                    }
                    Thread.sleep((long)(1000.0 / WebcamPanel.this.frequency));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                WebcamPanel.this.repaint();
            }
        }
    }
}

