/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.buildin.natives.Device;
import com.github.sarxos.webcam.ds.buildin.natives.OpenIMAJGrabber;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDevice
implements WebcamDevice {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDevice.class);
    private static final Dimension[] DIMENSIONS = new Dimension[]{new Dimension(176, 144), new Dimension(320, 240), new Dimension(352, 288), new Dimension(640, 400), new Dimension(640, 480)};
    private static final int[] BAND_OFFSETS = new int[]{0, 1, 2};
    private static final int[] BITS = new int[]{8, 8, 8};
    private static final int[] OFFSET = new int[]{0};
    private static final int DATA_TYPE = 0;
    private static final ColorSpace COLOR_SPACE = ColorSpace.getInstance(1000);
    private OpenIMAJGrabber grabber = null;
    private Device device = null;
    private Dimension size = null;
    private ComponentSampleModel sampleModel = null;
    private ColorModel colorModel = null;
    private boolean open = false;

    protected DefaultDevice(Device device) {
        this.device = device;
    }

    @Override
    public String getName() {
        return this.device.getNameStr() + " " + this.device.getIdentifierStr();
    }

    @Override
    public Dimension[] getSizes() {
        return DIMENSIONS;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
    }

    @Override
    public BufferedImage getImage() {
        if (!this.open) {
            throw new WebcamException("Cannot get image when webcam device is not open");
        }
        Pointer<Byte> image = this.grabber.getImage();
        if (image == null) {
            return null;
        }
        byte[] bytes = image.getBytes(this.size.width * this.size.height * 3);
        byte[][] data = new byte[][]{bytes};
        DataBufferByte buffer = new DataBufferByte(data, bytes.length, OFFSET);
        WritableRaster raster = Raster.createWritableRaster(this.sampleModel, buffer, null);
        BufferedImage bi = new BufferedImage(this.colorModel, raster, false, null);
        bi.flush();
        return bi;
    }

    @Override
    public void open() {
        if (this.open) {
            return;
        }
        this.grabber = new OpenIMAJGrabber();
        boolean started = this.grabber.startSession(this.size.width, this.size.height, 0.0, (Pointer<Device>)Pointer.pointerTo((NativeObject)this.device));
        if (!started) {
            throw new WebcamException("Cannot start video data grabber!");
        }
        int w1 = this.size.width;
        int w2 = this.grabber.getWidth();
        int h1 = this.size.height;
        int h2 = this.grabber.getHeight();
        if (w1 != w2 || h1 != h2) {
            LOG.warn("Different size obtained vs requested - [" + w1 + "x" + h1 + "] vs [" + w2 + "x" + h2 + "]. Setting correct one. New size is [" + w2 + "x" + h2 + "]");
            this.size = new Dimension(w2, h2);
        }
        this.sampleModel = new ComponentSampleModel(0, this.size.width, this.size.height, 3, this.size.width * 3, BAND_OFFSETS);
        this.colorModel = new ComponentColorModel(COLOR_SPACE, BITS, false, false, 1, 0);
        int i = 0;
        do {
            this.grabber.nextFrame();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (i++ < 3);
        this.open = true;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.grabber.stopSession();
        this.open = false;
    }
}

