/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoveryListener;
import com.github.sarxos.webcam.WebcamDiscoveryService;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamDriverUtils;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.ds.buildin.WebcamDefaultDriver;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Webcam {
    private static final Logger LOG = LoggerFactory.getLogger(Webcam.class);
    private static final String[] DRIVERS_DEFAULT = new String[]{"com.github.sarxos.webcam.ds.openimaj.OpenImajDriver", "com.github.sarxos.webcam.ds.civil.LtiCivilDriver", "com.github.sarxos.webcam.ds.jmf.JmfDriver"};
    private static final List<String> DRIVERS_LIST = new ArrayList<String>(Arrays.asList(DRIVERS_DEFAULT));
    private static final List<Class<?>> DRIVERS_CLASS_LIST = new ArrayList();
    private static final List<WebcamDiscoveryListener> DISCOVERY_LISTENERS = Collections.synchronizedList(new ArrayList());
    private static WebcamDriver driver = null;
    private static WebcamDiscoveryService discovery = null;
    private static volatile boolean deallocOnTermSignal = false;
    private List<WebcamListener> listeners = Collections.synchronizedList(new ArrayList());
    private List<Dimension> customSizes = new ArrayList<Dimension>();
    private ShutdownHook hook = null;
    private WebcamDevice device = null;
    private volatile boolean open = false;
    private volatile boolean disposed = false;
    private static long timeout = 60000L;

    protected Webcam(WebcamDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Webcam device cannot be null");
        }
        this.device = device;
    }

    private void ensureSize() {
        Dimension size = this.device.getSize();
        if (size == null) {
            Dimension[] sizes = this.device.getSizes();
            if (sizes == null) {
                throw new WebcamException("Sizes array from driver cannot be null!");
            }
            if (sizes.length == 0) {
                throw new WebcamException("Sizes array from driver is empty, cannot choose image size");
            }
            this.device.setSize(sizes[0]);
        }
    }

    public synchronized void open() {
        if (this.open) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Opening webcam " + this.getName());
        }
        this.ensureSize();
        this.device.open();
        this.open = true;
        this.hook = new ShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.hook);
        WebcamEvent we = new WebcamEvent(this);
        for (WebcamListener l : this.listeners) {
            try {
                l.webcamOpen(we);
            }
            catch (Exception e) {
                LOG.error(String.format("Notify webcam open, exception when calling listener %s", l.getClass()), (Throwable)e);
            }
        }
    }

    public synchronized void close() {
        if (!this.open) {
            return;
        }
        Runtime.getRuntime().removeShutdownHook(this.hook);
        this.close0();
    }

    private void close0() {
        if (!this.open) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Closing {}", (Object)this.getName());
        }
        this.device.close();
        this.open = false;
        WebcamEvent we = new WebcamEvent(this);
        for (WebcamListener l : this.listeners) {
            try {
                l.webcamClosed(we);
            }
            catch (Exception e) {
                LOG.error(String.format("Notify webcam closed, exception when calling %s listener", l.getClass()), (Throwable)e);
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public Dimension getViewSize() {
        return this.device.getSize();
    }

    public Dimension[] getViewSizes() {
        return this.device.getSizes();
    }

    public void setCustomViewSizes(Dimension[] sizes) {
        if (sizes == null) {
            this.customSizes.clear();
            return;
        }
        this.customSizes = Arrays.asList(sizes);
    }

    public Dimension[] getCustomViewSizes() {
        return this.customSizes.toArray(new Dimension[this.customSizes.size()]);
    }

    public void setViewSize(Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException("View size cannot be null!");
        }
        Dimension[] predefined = this.getViewSizes();
        Dimension[] custom = this.getCustomViewSizes();
        boolean ok = false;
        for (Dimension d : predefined) {
            if (d.width != size.width || d.height != size.height) continue;
            ok = true;
            break;
        }
        if (!ok) {
            for (Dimension d : custom) {
                if (d.width != size.width || d.height != size.height) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Incorrect dimension [");
            sb.append(size.width).append("x").append(size.height).append("] ");
            sb.append("possible ones are ");
            for (Dimension d : predefined) {
                sb.append("[").append(d.width).append("x").append(d.height).append("] ");
            }
            for (Dimension d : custom) {
                sb.append("[").append(d.width).append("x").append(d.height).append("] ");
            }
            throw new IllegalArgumentException(sb.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting new view size {} x {}", (Object)size.width, (Object)size.height);
        }
        this.device.setSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        if (this.disposed) {
            return null;
        }
        Webcam webcam = this;
        synchronized (webcam) {
            if (!this.open) {
                LOG.debug("Try to get image on closed webcam, opening it automatically");
                this.open();
            }
            return this.device.getImage();
        }
    }

    public static List<Webcam> getWebcams() {
        try {
            return Webcam.getWebcams(timeout);
        }
        catch (TimeoutException e) {
            throw new WebcamException(e);
        }
    }

    public static List<Webcam> getWebcams(long timeout) throws TimeoutException {
        return Webcam.getWebcams(timeout, TimeUnit.MILLISECONDS);
    }

    public static List<Webcam> getWebcams(long timeout, TimeUnit tunit) throws TimeoutException {
        WebcamDiscoveryService discovery = Webcam.getDiscoveryService();
        List<Webcam> webcams = discovery.getWebcams(timeout, tunit);
        if (!discovery.isRunning()) {
            discovery.start();
        }
        return webcams;
    }

    public static Webcam getDefault() {
        try {
            return Webcam.getDefault(timeout);
        }
        catch (TimeoutException e) {
            throw new WebcamException(e);
        }
    }

    public static Webcam getDefault(long timeout) throws TimeoutException {
        return Webcam.getDefault(timeout, TimeUnit.MILLISECONDS);
    }

    public static Webcam getDefault(long timeout, TimeUnit tunit) throws TimeoutException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit cannot be null!");
        }
        List<Webcam> webcams = Webcam.getWebcams(timeout, tunit);
        if (webcams.isEmpty()) {
            throw new WebcamException("No webcam available in the system");
        }
        return webcams.get(0);
    }

    public String getName() {
        return this.device.getName();
    }

    public String toString() {
        return String.format("Webcam %s", this.getName());
    }

    public boolean addWebcamListener(WebcamListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Webcam listener cannot be null!");
        }
        return this.listeners.add(l);
    }

    public WebcamListener[] getWebcamListeners() {
        return this.listeners.toArray(new WebcamListener[this.listeners.size()]);
    }

    public boolean removeWebcamListener(WebcamListener l) {
        return this.listeners.remove(l);
    }

    public static WebcamDriver getDriver() {
        if (driver == null) {
            driver = WebcamDriverUtils.findDriver(DRIVERS_LIST, DRIVERS_CLASS_LIST);
        }
        if (driver == null) {
            LOG.info("Webcam driver has not been found, default one will be used!");
            driver = new WebcamDefaultDriver();
        }
        return driver;
    }

    public static void setDriver(WebcamDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("Webcam driver cannot be null!");
        }
        Webcam.resetDriver();
        Webcam.driver = driver;
    }

    public static void setDriver(Class<? extends WebcamDriver> driverClass) {
        Webcam.resetDriver();
        if (driverClass == null) {
            throw new IllegalArgumentException("Webcam driver class cannot be null!");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new WebcamException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebcamException(e);
        }
    }

    public static void resetDriver() {
        DRIVERS_LIST.clear();
        DRIVERS_LIST.addAll(Arrays.asList(DRIVERS_DEFAULT));
        driver = null;
        if (discovery != null) {
            discovery.dispose();
            discovery = null;
        }
    }

    public static void registerDriver(Class<? extends WebcamDriver> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Webcam driver class to register cannot be null!");
        }
        DRIVERS_CLASS_LIST.add(clazz);
        Webcam.registerDriver(clazz.getCanonicalName());
    }

    public static void registerDriver(String clazzName) {
        if (clazzName == null) {
            throw new IllegalArgumentException("Webcam driver class name to register cannot be null!");
        }
        DRIVERS_LIST.add(clazzName);
    }

    public WebcamDevice getDevice() {
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        LOG.info("Disposing webcam {}", (Object)this.getName());
        if (this.hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.open = false;
        this.disposed = true;
        WebcamEvent we = new WebcamEvent(this);
        for (WebcamListener l : this.listeners) {
            try {
                l.webcamClosed(we);
                l.webcamDisposed(we);
            }
            catch (Exception e) {
                LOG.error(String.format("Notify webcam disposed, exception when calling %s listener", l.getClass()), (Throwable)e);
            }
        }
        Webcam webcam = this;
        synchronized (webcam) {
            this.device.close();
            this.device.dispose();
        }
    }

    public static void setHandleTermSignal(boolean on) {
        if (on) {
            LOG.warn("Automated deallocation on TERM signal is now enabled! Make sure to not use it in production!");
        }
        deallocOnTermSignal = on;
    }

    public static boolean isHandleTermSignal() {
        return deallocOnTermSignal;
    }

    public static boolean addDiscoveryListener(WebcamDiscoveryListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Webcam discovery listener cannot be null!");
        }
        return DISCOVERY_LISTENERS.add(l);
    }

    public static WebcamDiscoveryListener[] getDiscoveryListeners() {
        return DISCOVERY_LISTENERS.toArray(new WebcamDiscoveryListener[DISCOVERY_LISTENERS.size()]);
    }

    public static boolean removeDiscoveryListener(WebcamDiscoveryListener l) {
        return DISCOVERY_LISTENERS.remove(l);
    }

    public static WebcamDiscoveryService getDiscoveryService() {
        if (discovery == null) {
            discovery = new WebcamDiscoveryService(Webcam.getDriver());
        }
        return discovery;
    }

    public static void setDiscoveryTimeout(long timeout) {
        Webcam.timeout = timeout;
    }

    public static long getDiscoveryTimeout() {
        return timeout;
    }

    private static final class ShutdownHook
    extends Thread {
        private Webcam webcam = null;

        public ShutdownHook(Webcam webcam) {
            this.webcam = webcam;
        }

        @Override
        public void run() {
            LOG.info("Automatic resource deallocation");
            super.run();
            this.webcam.dispose();
            this.webcam.close0();
        }
    }
}

