/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamMotionEvent;
import com.github.sarxos.webcam.WebcamMotionListener;
import com.jhlabs.image.BoxBlurFilter;
import com.jhlabs.image.GrayscaleFilter;
import com.jhlabs.image.PixelUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamMotionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamMotionDetector.class);
    public static final int DEFAULT_THREASHOLD = 25;
    private List<WebcamMotionListener> listeners = new ArrayList<WebcamMotionListener>();
    private Object mutex = new Object();
    private boolean running = false;
    private boolean motion = false;
    private BufferedImage previous = null;
    private Webcam webcam = null;
    private int interval = 1000;
    private int threshold = 10;
    private int inertia = 10000;
    private int strength = 0;
    private BoxBlurFilter blur = new BoxBlurFilter(3, 3, 1);
    private GrayscaleFilter gray = new GrayscaleFilter();
    private int number = 0;
    private ThreadFactory threadFactory = new DetectorThreadFactory();
    private ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);

    public WebcamMotionDetector(Webcam webcam, int threshold, int inertia) {
        this.webcam = webcam;
        this.threshold = threshold;
        this.inertia = inertia;
    }

    public WebcamMotionDetector(Webcam webcam, int threshold) {
        this(webcam, threshold, 0);
    }

    public WebcamMotionDetector(Webcam webcam) {
        this(webcam, 25, 0);
    }

    public void start() {
        if (!this.webcam.isOpen()) {
            this.webcam.open();
        }
        LOG.debug("Starting motion detector");
        this.executor.submit(new Runner());
    }

    public void stop() {
        this.running = false;
        if (this.webcam.isOpen()) {
            this.webcam.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(WebcamMotionDetector.class.getSimpleName() + ".detect()");
        }
        if (this.motion) {
            LOG.debug("Motion detector still in inertia state, no need to check");
            return;
        }
        BufferedImage current = this.webcam.getImage();
        current = this.blur.filter(current, null);
        current = this.gray.filter(current, null);
        if (this.previous != null) {
            int w = current.getWidth();
            int h = current.getHeight();
            int strength = 0;
            Object object = this.mutex;
            synchronized (object) {
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < h; ++j) {
                        int c = current.getRGB(i, j);
                        int p = this.previous.getRGB(i, j);
                        int rgb = PixelUtils.combinePixels((int)c, (int)p, (int)6);
                        int cr = (rgb & 0xFF0000) >> 16;
                        int cg = (rgb & 0xFF00) >> 8;
                        int cb = rgb & 0xFF;
                        int max = Math.max(Math.max(cr, cg), cb);
                        if (max <= this.threshold) continue;
                        if (!this.motion) {
                            this.executor.submit(new Changer());
                            this.motion = true;
                        }
                        ++strength;
                    }
                }
                this.strength = strength;
                if (this.motion) {
                    this.notifyMotionListeners();
                }
            }
        }
        this.previous = current;
    }

    private void notifyMotionListeners() {
        WebcamMotionEvent wme = new WebcamMotionEvent(this, this.strength);
        for (WebcamMotionListener l : this.listeners) {
            try {
                l.motionDetected(wme);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean addMotionListener(WebcamMotionListener l) {
        return this.listeners.add(l);
    }

    public WebcamMotionListener[] getMotionListeners() {
        return this.listeners.toArray(new WebcamMotionListener[this.listeners.size()]);
    }

    public boolean removeMotionListener(WebcamMotionListener l) {
        return this.listeners.remove(l);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public Webcam getWebcam() {
        return this.webcam;
    }

    public boolean isMotion() {
        if (!this.running) {
            LOG.warn("Motion cannot be detected when detector is not running!");
        }
        return this.motion;
    }

    public int getMotionStrength() {
        return this.strength;
    }

    private class Changer
    implements Runnable {
        private Changer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int time = WebcamMotionDetector.this.inertia == 0 ? WebcamMotionDetector.this.interval + WebcamMotionDetector.this.interval / 2 : WebcamMotionDetector.this.inertia;
            LOG.debug("Motion change has been sheduled in " + time + "ms");
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Object object = WebcamMotionDetector.this.mutex;
            synchronized (object) {
                WebcamMotionDetector.this.motion = false;
            }
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            WebcamMotionDetector.this.running = true;
            while (WebcamMotionDetector.this.running && WebcamMotionDetector.this.webcam.isOpen()) {
                WebcamMotionDetector.this.detect();
                try {
                    Thread.sleep(WebcamMotionDetector.this.interval);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class DetectorThreadFactory
    implements ThreadFactory {
        private DetectorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "motion-detector-" + WebcamMotionDetector.this.number++);
            t.setDaemon(true);
            return t;
        }
    }
}

