/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamResolution;
import com.github.sarxos.webcam.ds.buildin.WebcamGrabberProcessor;
import com.github.sarxos.webcam.ds.buildin.cgt.CloseSessionTask;
import com.github.sarxos.webcam.ds.buildin.cgt.GetImageTask;
import com.github.sarxos.webcam.ds.buildin.cgt.GetSizeTask;
import com.github.sarxos.webcam.ds.buildin.cgt.NextFrameTask;
import com.github.sarxos.webcam.ds.buildin.cgt.StartSessionTask;
import com.github.sarxos.webcam.ds.buildin.natives.Device;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDefaultDevice
implements WebcamDevice {
    private static final Logger LOG;
    private static final Dimension[] DIMENSIONS;
    private static final int[] BAND_OFFSETS;
    private static final int[] BITS;
    private static final int[] OFFSET;
    private static final int DATA_TYPE = 0;
    private static final ColorSpace COLOR_SPACE;
    private final WebcamGrabberProcessor processor = new WebcamGrabberProcessor();
    private final NextFrameTask frameTask = new NextFrameTask(this.processor);
    private final GetImageTask imageTask = new GetImageTask(this.processor);
    private final StartSessionTask sessionTask = new StartSessionTask(this.processor);
    private final GetSizeTask sizeTask = new GetSizeTask(this.processor);
    private final CloseSessionTask closeTask = new CloseSessionTask(this.processor);
    private Device device = null;
    private Dimension size = null;
    private ComponentSampleModel sampleModel = null;
    private ColorModel colorModel = null;
    private boolean failOnSizeMismatch = false;
    private volatile boolean open = false;
    private volatile boolean opening = false;
    private volatile boolean disposed = false;
    private String name = null;
    private String id = null;
    private String fullname = null;

    protected WebcamDefaultDevice(Device device) {
        this.device = device;
        this.name = device.getNameStr();
        this.id = device.getIdentifierStr();
        this.fullname = String.format("%s %s", this.name, this.id);
    }

    @Override
    public String getName() {
        return this.fullname;
    }

    @Override
    public Dimension[] getSizes() {
        return DIMENSIONS;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
    }

    @Override
    public BufferedImage getImage() {
        if (this.disposed) {
            throw new WebcamException("Cannot get image since device is already disposed");
        }
        if (!this.open) {
            LOG.error("Cannot get image when device is closed");
            return null;
        }
        this.frameTask.nextFrame();
        byte[] bytes = this.imageTask.getImage(this.size);
        byte[][] data = new byte[][]{bytes};
        if (bytes == null) {
            LOG.error("Images byte array is null!");
            return null;
        }
        DataBufferByte buffer = new DataBufferByte(data, bytes.length, OFFSET);
        WritableRaster raster = Raster.createWritableRaster(this.sampleModel, buffer, null);
        BufferedImage bi = new BufferedImage(this.colorModel, raster, false, null);
        bi.flush();
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.disposed) {
            throw new WebcamException("Cannot open webcam when device it's already disposed");
        }
        Device device = this.device;
        synchronized (device) {
            if (this.opening) {
                try {
                    ((Object)((Object)this.device)).wait();
                }
                catch (InterruptedException e) {
                    throw new WebcamException("Opening wait interrupted");
                }
                finally {
                    this.opening = false;
                }
            }
            if (this.open) {
                return;
            }
            this.opening = true;
        }
        if (this.size == null) {
            this.size = this.getSizes()[0];
        }
        try {
            boolean started = this.sessionTask.startSession(this.size, this.device);
            if (!started) {
                throw new WebcamException("Cannot start video data grabber!");
            }
            Dimension size2 = this.sizeTask.getSize();
            int w1 = this.size.width;
            int w2 = size2.width;
            int h1 = this.size.height;
            int h2 = size2.height;
            if (w1 != w2 || h1 != h2) {
                if (this.failOnSizeMismatch) {
                    throw new WebcamException(String.format("Different size obtained vs requested - [%dx%d] vs [%dx%d]", w1, h1, w2, h2));
                }
                LOG.warn("Different size obtained vs requested - [{}x{}] vs [{}x{}]. Setting correct one. New size is [{}x{}]", new Object[]{w1, h1, w2, h2, w2, h2});
                this.size = new Dimension(w2, h2);
            }
            this.sampleModel = new ComponentSampleModel(0, this.size.width, this.size.height, 3, this.size.width * 3, BAND_OFFSETS);
            this.colorModel = new ComponentColorModel(COLOR_SPACE, BITS, false, false, 1, 0);
            int i = 0;
            do {
                this.frameTask.nextFrame();
                this.imageTask.getImage(this.size);
                if (this.disposed) {
                    this.opening = false;
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Nasty interrupted exception", (Throwable)e);
                }
            } while (i++ < 3);
            this.open = true;
            this.opening = false;
        }
        finally {
            Device device2 = this.device;
            synchronized (device2) {
                ((Object)((Object)this.device)).notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        Device device = this.device;
        synchronized (device) {
            this.closeTask.closeSession();
            this.open = false;
        }
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.close();
        this.disposed = true;
    }

    public void setFailOnSizeMismatch(boolean fail) {
        this.failOnSizeMismatch = fail;
    }

    static {
        if (!"true".equals(System.getProperty("webcam.debug"))) {
            System.setProperty("bridj.quiet", "true");
        }
        LOG = LoggerFactory.getLogger(WebcamDefaultDevice.class);
        DIMENSIONS = new Dimension[]{WebcamResolution.QQVGA.getSize(), WebcamResolution.QVGA.getSize(), WebcamResolution.CIF.getSize(), WebcamResolution.HVGA.getSize(), WebcamResolution.VGA.getSize(), WebcamResolution.XGA.getSize()};
        BAND_OFFSETS = new int[]{0, 1, 2};
        BITS = new int[]{8, 8, 8};
        OFFSET = new int[]{0};
        COLOR_SPACE = ColorSpace.getInstance(1000);
    }
}

