/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoverySupport;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.ds.buildin.WebcamDefaultDevice;
import com.github.sarxos.webcam.ds.buildin.WebcamGrabberProcessor;
import com.github.sarxos.webcam.ds.buildin.cgt.GetDevicesTask;
import com.github.sarxos.webcam.ds.buildin.natives.Device;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDefaultDriver
implements WebcamDriver,
WebcamDiscoverySupport {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDefaultDriver.class);
    private static final WebcamGrabberProcessor processor = new WebcamGrabberProcessor();
    private static final GetDevicesTask DEVICES_TASK = new GetDevicesTask(processor);

    @Override
    public List<WebcamDevice> getDevices() {
        LOG.debug("Searching devices");
        ArrayList<WebcamDevice> devices = new ArrayList<WebcamDevice>();
        for (Device device : DEVICES_TASK.getDevices()) {
            devices.add(new WebcamDefaultDevice(device));
        }
        if (LOG.isDebugEnabled()) {
            for (WebcamDevice webcamDevice : devices) {
                LOG.debug("Found device {}", (Object)webcamDevice.getName());
            }
        }
        return devices;
    }

    @Override
    public long getScanInterval() {
        return 3000L;
    }

    @Override
    public boolean isScanPossible() {
        return true;
    }
}

