/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.buildin.WebcamGrabberTask;
import com.github.sarxos.webcam.ds.buildin.natives.OpenIMAJGrabber;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class WebcamGrabberProcessor {
    private static final SynchronousQueue<WebcamGrabberTask> tasks = new SynchronousQueue(true);
    private static final Executor runner = Executors.newSingleThreadExecutor(new ProcessorThreadFactory());
    private static final StaticProcessor processor = new StaticProcessor();
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private OpenIMAJGrabber grabber = null;

    protected WebcamGrabberProcessor() {
        if (started.compareAndSet(false, true)) {
            runner.execute(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(WebcamGrabberTask task) {
        Object object = this;
        synchronized (object) {
            if (this.grabber == null) {
                NewGrabberTask grabberTask = new NewGrabberTask();
                try {
                    NewGrabberTask newGrabberTask = grabberTask;
                    synchronized (newGrabberTask) {
                        tasks.offer(grabberTask);
                        grabberTask.wait();
                        this.grabber = grabberTask.getGrabber();
                    }
                }
                catch (InterruptedException e) {
                    throw new WebcamException("Grabber creation interrupted", e);
                }
            }
        }
        try {
            object = task;
            synchronized (object) {
                task.setGrabber(this.grabber);
                tasks.offer(task, 30L, TimeUnit.MINUTES);
                task.wait();
            }
        }
        catch (InterruptedException e) {
            throw new WebcamException("Offer interrupted", e);
        }
    }

    private static final class NewGrabberTask
    extends WebcamGrabberTask {
        private volatile OpenIMAJGrabber grabber = null;

        private NewGrabberTask() {
        }

        public OpenIMAJGrabber getGrabber() {
            return this.grabber;
        }

        @Override
        protected void handle() {
            this.grabber = new OpenIMAJGrabber();
        }
    }

    private static final class StaticProcessor
    implements Runnable {
        private StaticProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WebcamGrabberTask task = null;
                try {
                    task = (WebcamGrabberTask)tasks.take();
                    task.handle();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new WebcamException("Take interrupted", e);
                }
                finally {
                    WebcamGrabberTask webcamGrabberTask = task;
                    synchronized (webcamGrabberTask) {
                        task.notifyAll();
                    }
                    continue;
                }
                break;
            }
        }
    }

    private static final class ProcessorThreadFactory
    implements ThreadFactory {
        private ProcessorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.getClass().getSimpleName());
            t.setDaemon(true);
            return t;
        }
    }
}

