/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoveryListener;
import com.github.sarxos.webcam.WebcamDiscoveryService;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamDriverUtils;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamProcessor;
import com.github.sarxos.webcam.ds.buildin.WebcamDefaultDriver;
import com.github.sarxos.webcam.ds.cgt.WebcamCloseTask;
import com.github.sarxos.webcam.ds.cgt.WebcamDisposeTask;
import com.github.sarxos.webcam.ds.cgt.WebcamOpenTask;
import com.github.sarxos.webcam.ds.cgt.WebcamReadBufferTask;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Webcam {
    private static final Logger LOG = LoggerFactory.getLogger(Webcam.class);
    private static final String[] DRIVERS_DEFAULT = new String[]{"com.github.sarxos.webcam.ds.openimaj.OpenImajDriver", "com.github.sarxos.webcam.ds.civil.LtiCivilDriver", "com.github.sarxos.webcam.ds.jmf.JmfDriver"};
    private static final List<String> DRIVERS_LIST = new ArrayList<String>(Arrays.asList(DRIVERS_DEFAULT));
    private static final List<Class<?>> DRIVERS_CLASS_LIST = new ArrayList();
    private static final List<WebcamDiscoveryListener> DISCOVERY_LISTENERS = Collections.synchronizedList(new ArrayList());
    private static WebcamDriver driver = null;
    private static WebcamProcessor processor = new WebcamProcessor();
    private static volatile WebcamDiscoveryService discovery = null;
    private static boolean deallocOnTermSignal = false;
    private static boolean autoOpen = false;
    private List<WebcamListener> listeners = Collections.synchronizedList(new ArrayList());
    private List<Dimension> customSizes = new ArrayList<Dimension>();
    private ShutdownHook hook = null;
    private WebcamDevice device = null;
    private AtomicBoolean open = new AtomicBoolean(false);
    private AtomicBoolean disposed = new AtomicBoolean(false);

    protected Webcam(WebcamDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Webcam device cannot be null");
        }
        this.device = device;
    }

    public void open() {
        if (!this.open.compareAndSet(false, true)) {
            LOG.debug("Webcam is already open {}", (Object)this.getName());
            return;
        }
        WebcamOpenTask task = new WebcamOpenTask(this);
        task.open(this);
        this.hook = new ShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    public void close() {
        if (!this.open.compareAndSet(true, false)) {
            LOG.debug("Webcam is already closed {}", (Object)this.getName());
            return;
        }
        WebcamCloseTask task = new WebcamCloseTask(this);
        task.close(this);
        Runtime.getRuntime().removeShutdownHook(this.hook);
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public Dimension getViewSize() {
        return this.device.getResolution();
    }

    public Dimension[] getViewSizes() {
        return this.device.getResolutions();
    }

    public void setCustomViewSizes(Dimension[] sizes) {
        if (sizes == null) {
            this.customSizes.clear();
            return;
        }
        this.customSizes = Arrays.asList(sizes);
    }

    public Dimension[] getCustomViewSizes() {
        return this.customSizes.toArray(new Dimension[this.customSizes.size()]);
    }

    public void setViewSize(Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException("Resolution cannot be null!");
        }
        if (this.open.get()) {
            throw new IllegalStateException("Cannot change resolution when webcam is open, please close it first");
        }
        Dimension current = this.getViewSize();
        if (current != null && current.width == size.width && current.height == size.height) {
            return;
        }
        Dimension[] predefined = this.getViewSizes();
        Dimension[] custom = this.getCustomViewSizes();
        boolean ok = false;
        for (Dimension d : predefined) {
            if (d.width != size.width || d.height != size.height) continue;
            ok = true;
            break;
        }
        if (!ok) {
            for (Dimension d : custom) {
                if (d.width != size.width || d.height != size.height) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Incorrect dimension [");
            sb.append(size.width).append("x").append(size.height).append("] ");
            sb.append("possible ones are ");
            for (Dimension d : predefined) {
                sb.append("[").append(d.width).append("x").append(d.height).append("] ");
            }
            for (Dimension d : custom) {
                sb.append("[").append(d.width).append("x").append(d.height).append("] ");
            }
            throw new IllegalArgumentException(sb.toString());
        }
        LOG.debug("Setting new resolution {}x{}", (Object)size.width, (Object)size.height);
        this.device.setResolution(size);
    }

    public BufferedImage getImage() {
        if (this.disposed.get()) {
            LOG.warn("Cannot get image, webcam has been already disposed");
            return null;
        }
        if (!this.open.get()) {
            if (autoOpen) {
                this.open();
            } else {
                return null;
            }
        }
        WebcamReadBufferTask task = new WebcamReadBufferTask(this);
        return task.getImage();
    }

    public static List<Webcam> getWebcams() throws WebcamException {
        try {
            return Webcam.getWebcams(Long.MAX_VALUE);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Webcam> getWebcams(long timeout) throws TimeoutException, WebcamException {
        return Webcam.getWebcams(timeout, TimeUnit.MILLISECONDS);
    }

    public static synchronized List<Webcam> getWebcams(long timeout, TimeUnit tunit) throws TimeoutException, WebcamException {
        WebcamDiscoveryService discovery = Webcam.getDiscoveryService();
        List<Webcam> webcams = discovery.getWebcams(timeout, tunit);
        if (!discovery.isRunning()) {
            discovery.start();
        }
        return webcams;
    }

    public static Webcam getDefault() throws WebcamException {
        try {
            return Webcam.getDefault(Long.MAX_VALUE);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static Webcam getDefault(long timeout) throws TimeoutException, WebcamException {
        return Webcam.getDefault(timeout, TimeUnit.MILLISECONDS);
    }

    public static Webcam getDefault(long timeout, TimeUnit tunit) throws TimeoutException, WebcamException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit cannot be null!");
        }
        List<Webcam> webcams = Webcam.getWebcams(timeout, tunit);
        if (!webcams.isEmpty()) {
            return webcams.get(0);
        }
        LOG.warn("No webcam has been detected!");
        return null;
    }

    public String getName() {
        return this.device.getName();
    }

    public String toString() {
        return String.format("Webcam %s", this.getName());
    }

    public boolean addWebcamListener(WebcamListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Webcam listener cannot be null!");
        }
        return this.listeners.add(l);
    }

    public WebcamListener[] getWebcamListeners() {
        return this.listeners.toArray(new WebcamListener[this.listeners.size()]);
    }

    public boolean removeWebcamListener(WebcamListener l) {
        return this.listeners.remove(l);
    }

    public static synchronized WebcamDriver getDriver() {
        if (driver == null) {
            driver = WebcamDriverUtils.findDriver(DRIVERS_LIST, DRIVERS_CLASS_LIST);
        }
        if (driver == null) {
            LOG.info("Webcam driver has not been found, default one will be used!");
            driver = new WebcamDefaultDriver();
        }
        return driver;
    }

    public static synchronized void setDriver(WebcamDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("Webcam driver cannot be null!");
        }
        Webcam.resetDriver();
        Webcam.driver = driver;
    }

    public static synchronized void setDriver(Class<? extends WebcamDriver> driverClass) {
        Webcam.resetDriver();
        if (driverClass == null) {
            throw new IllegalArgumentException("Webcam driver class cannot be null!");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new WebcamException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebcamException(e);
        }
    }

    public static synchronized void resetDriver() {
        DRIVERS_LIST.clear();
        DRIVERS_LIST.addAll(Arrays.asList(DRIVERS_DEFAULT));
        if (discovery != null) {
            discovery.shutdown();
            discovery = null;
        }
        driver = null;
    }

    public static void registerDriver(Class<? extends WebcamDriver> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Webcam driver class to register cannot be null!");
        }
        DRIVERS_CLASS_LIST.add(clazz);
        Webcam.registerDriver(clazz.getCanonicalName());
    }

    public static void registerDriver(String clazzName) {
        if (clazzName == null) {
            throw new IllegalArgumentException("Webcam driver class name to register cannot be null!");
        }
        DRIVERS_LIST.add(clazzName);
    }

    public WebcamDevice getDevice() {
        return this.device;
    }

    protected WebcamProcessor getProcessor() {
        return processor;
    }

    protected void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.open.set(false);
        LOG.info("Disposing webcam {}", (Object)this.getName());
        WebcamDisposeTask task = new WebcamDisposeTask(this);
        task.dispose();
        WebcamEvent we = new WebcamEvent(this);
        for (WebcamListener l : this.listeners) {
            try {
                l.webcamClosed(we);
                l.webcamDisposed(we);
            }
            catch (Exception e) {
                LOG.error(String.format("Notify webcam disposed, exception when calling %s listener", l.getClass()), (Throwable)e);
            }
        }
        if (this.hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        LOG.debug("Webcam disposed {}", (Object)this.getName());
    }

    public static void setHandleTermSignal(boolean on) {
        if (on) {
            LOG.warn("Automated deallocation on TERM signal is now enabled! Make sure to not use it in production!");
        }
        deallocOnTermSignal = on;
    }

    public static boolean isHandleTermSignal() {
        return deallocOnTermSignal;
    }

    public static void setAutoOpenMode(boolean on) {
        autoOpen = on;
    }

    public static boolean isAutoOpenMode() {
        return autoOpen;
    }

    public static boolean addDiscoveryListener(WebcamDiscoveryListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Webcam discovery listener cannot be null!");
        }
        return DISCOVERY_LISTENERS.add(l);
    }

    public static WebcamDiscoveryListener[] getDiscoveryListeners() {
        return DISCOVERY_LISTENERS.toArray(new WebcamDiscoveryListener[DISCOVERY_LISTENERS.size()]);
    }

    public static boolean removeDiscoveryListener(WebcamDiscoveryListener l) {
        return DISCOVERY_LISTENERS.remove(l);
    }

    public static synchronized WebcamDiscoveryService getDiscoveryService() {
        if (discovery == null) {
            discovery = new WebcamDiscoveryService(Webcam.getDriver());
        }
        return discovery;
    }

    private static final class ShutdownHook
    extends Thread {
        private static int number = 0;
        private Webcam webcam = null;

        public ShutdownHook(Webcam webcam) {
            super("shutdown-hook-" + ++number);
            this.webcam = webcam;
        }

        @Override
        public void run() {
            LOG.info("Automatic {} deallocation", (Object)this.webcam.getName());
            this.webcam.dispose();
        }
    }
}

