/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDeallocator;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoveryEvent;
import com.github.sarxos.webcam.WebcamDiscoveryListener;
import com.github.sarxos.webcam.WebcamDiscoverySupport;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDiscoveryService
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDiscoveryService.class);
    private final WebcamDriver driver;
    private final WebcamDiscoverySupport support;
    private volatile List<Webcam> webcams = null;
    private volatile boolean running = false;
    private Thread runner = null;

    protected WebcamDiscoveryService(WebcamDriver driver) {
        this.driver = driver;
        this.support = (WebcamDiscoverySupport)((Object)(driver instanceof WebcamDiscoverySupport ? driver : null));
    }

    private static List<Webcam> toWebcams(List<WebcamDevice> devices) {
        ArrayList<Webcam> webcams = new ArrayList<Webcam>();
        for (WebcamDevice device : devices) {
            webcams.add(new Webcam(device));
        }
        return webcams;
    }

    private static List<WebcamDevice> getDevices(List<Webcam> webcams) {
        ArrayList<WebcamDevice> devices = new ArrayList<WebcamDevice>();
        for (Webcam webcam : webcams) {
            devices.add(webcam.getDevice());
        }
        return devices;
    }

    public synchronized List<Webcam> getWebcams(long timeout, TimeUnit tunit) throws TimeoutException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit cannot be null!");
        }
        if (this.webcams == null) {
            WebcamsDiscovery discovery = new WebcamsDiscovery(this.driver);
            ExecutorService executor = Executors.newSingleThreadExecutor(discovery);
            Future<List<Webcam>> future = executor.submit(discovery);
            executor.shutdown();
            try {
                executor.awaitTermination(timeout, tunit);
                if (future.isDone()) {
                    this.webcams = future.get();
                } else {
                    future.cancel(true);
                }
            }
            catch (InterruptedException e) {
                throw new WebcamException(e);
            }
            catch (ExecutionException e) {
                throw new WebcamException(e);
            }
            if (this.webcams == null) {
                throw new TimeoutException(String.format("Webcams discovery timeout (%d ms) has been exceeded", timeout));
            }
            WebcamDiscoveryListener[] listeners = Webcam.getDiscoveryListeners();
            for (Webcam webcam : this.webcams) {
                WebcamDiscoveryService.notifyWebcamFound(webcam, listeners);
            }
            if (Webcam.isHandleTermSignal()) {
                WebcamDeallocator.store(this.webcams.toArray(new Webcam[this.webcams.size()]));
            }
        }
        return Collections.unmodifiableList(this.webcams);
    }

    @Override
    public void run() {
        if (this.support == null) {
            return;
        }
        this.running = true;
        do {
            this.delay();
            WebcamDiscoveryListener[] listeners = Webcam.getDiscoveryListeners();
            if (listeners.length == 0) continue;
            List<WebcamDevice> tmpnew = this.driver.getDevices();
            List<WebcamDevice> tmpold = null;
            try {
                tmpold = WebcamDiscoveryService.getDevices(this.getWebcams(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                throw new WebcamException(e);
            }
            LinkedList<WebcamDevice> oldones = new LinkedList<WebcamDevice>(tmpold);
            LinkedList<WebcamDevice> newones = new LinkedList<WebcamDevice>(tmpnew);
            Iterator oi = oldones.iterator();
            Iterator ni = null;
            WebcamDevice od = null;
            WebcamDevice nd = null;
            block3: while (oi.hasNext()) {
                od = (WebcamDevice)oi.next();
                ni = newones.iterator();
                while (ni.hasNext()) {
                    nd = (WebcamDevice)ni.next();
                    if (!nd.getName().equals(od.getName())) continue;
                    ni.remove();
                    oi.remove();
                    continue block3;
                }
            }
            if (oldones.size() > 0) {
                ArrayList<Webcam> notified = new ArrayList<Webcam>();
                block5: for (WebcamDevice device : oldones) {
                    for (Webcam webcam : this.webcams) {
                        if (!webcam.getDevice().getName().equals(device.getName())) continue;
                        notified.add(webcam);
                        continue block5;
                    }
                }
                this.setCurrentWebcams(tmpnew);
                for (Webcam webcam : notified) {
                    WebcamDiscoveryService.notifyWebcamGone(webcam, listeners);
                    webcam.dispose();
                }
            }
            if (newones.size() <= 0) continue;
            this.setCurrentWebcams(tmpnew);
            block8: for (WebcamDevice device : newones) {
                for (Webcam webcam : this.webcams) {
                    if (!webcam.getDevice().getName().equals(device.getName())) continue;
                    WebcamDiscoveryService.notifyWebcamFound(webcam, listeners);
                    continue block8;
                }
            }
        } while (this.running);
    }

    private void setCurrentWebcams(List<WebcamDevice> devices) {
        this.webcams = WebcamDiscoveryService.toWebcams(devices);
        if (Webcam.isHandleTermSignal()) {
            WebcamDeallocator.unstore();
            WebcamDeallocator.store(this.webcams.toArray(new Webcam[this.webcams.size()]));
        }
    }

    private static void notifyWebcamGone(Webcam webcam, WebcamDiscoveryListener[] listeners) {
        WebcamDiscoveryEvent event = new WebcamDiscoveryEvent(webcam, 2);
        for (WebcamDiscoveryListener l : listeners) {
            try {
                l.webcamGone(event);
            }
            catch (Exception e) {
                LOG.error(String.format("Webcam gone, exception when calling listener %s", l.getClass()), (Throwable)e);
            }
        }
    }

    private static void notifyWebcamFound(Webcam webcam, WebcamDiscoveryListener[] listeners) {
        WebcamDiscoveryEvent event = new WebcamDiscoveryEvent(webcam, 1);
        for (WebcamDiscoveryListener l : listeners) {
            try {
                l.webcamFound(event);
            }
            catch (Exception e) {
                LOG.error(String.format("Webcam found, exception when calling listener %s", l.getClass()), (Throwable)e);
            }
        }
    }

    private void delay() {
        try {
            Thread.sleep(this.support.getScanInterval());
        }
        catch (InterruptedException e) {
            throw new WebcamException(e);
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.runner != null) {
            return;
        }
        try {
            this.runner.join();
        }
        catch (InterruptedException e) {
            throw new WebcamException("Joint interrupted");
        }
        this.runner = null;
    }

    public synchronized void start() {
        if (this.runner != null) {
            return;
        }
        this.runner = new Thread((Runnable)this, "webcam-discovery-service");
        this.runner.setDaemon(true);
        this.runner.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    protected synchronized void shutdown() {
        this.stop();
        for (Webcam webcam : this.webcams) {
            webcam.dispose();
        }
        this.webcams.clear();
        if (Webcam.isHandleTermSignal()) {
            WebcamDeallocator.unstore();
        }
    }

    private static final class WebcamsDiscovery
    implements Callable<List<Webcam>>,
    ThreadFactory {
        private final WebcamDriver driver;

        public WebcamsDiscovery(WebcamDriver driver) {
            this.driver = driver;
        }

        @Override
        public List<Webcam> call() throws Exception {
            return WebcamDiscoveryService.toWebcams(this.driver.getDevices());
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "webcam-discovery");
            t.setDaemon(true);
            return t;
        }
    }
}

