/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamPanel
extends JPanel
implements WebcamListener {
    private static final long serialVersionUID = 5792962512394656227L;
    private static final Logger LOG = LoggerFactory.getLogger(WebcamPanel.class);
    public static final double MIN_FREQUENCY = 0.016;
    private static final double MAX_FREQUENCY = 25.0;
    private boolean fillArea = false;
    private double frequency = 5.0;
    private Webcam webcam = null;
    private BufferedImage image = null;
    private Repainter repainter = new Repainter();
    private volatile boolean starting = false;
    private volatile boolean paused = false;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Painter painter = new DefaultPainter();

    public WebcamPanel(Webcam webcam) {
        this(webcam, true);
    }

    public WebcamPanel(Webcam webcam, boolean start) {
        this(webcam, null, start);
    }

    public WebcamPanel(Webcam webcam, Dimension size, boolean start) {
        if (webcam == null) {
            throw new IllegalArgumentException(String.format("Webcam argument in %s constructor cannot be null!", this.getClass().getSimpleName()));
        }
        this.webcam = webcam;
        this.webcam.addWebcamListener(this);
        this.repainter.setName(String.format("%s-repainter", webcam.getName()));
        if (size == null) {
            Dimension r = webcam.getViewSize();
            if (r == null) {
                r = webcam.getViewSizes()[0];
            }
            this.setPreferredSize(r);
        } else {
            this.setPreferredSize(size);
        }
        if (start) {
            if (!webcam.isOpen()) {
                webcam.open();
            }
            this.repainter.start();
        }
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.image == null) {
            this.painter.paintPanel(this, g2);
        } else {
            this.painter.paintImage(this, this.image, g2);
        }
    }

    @Override
    public void webcamOpen(WebcamEvent we) {
        if (this.repainter == null) {
            this.repainter = new Repainter();
            this.repainter.start();
        }
        this.setPreferredSize(this.webcam.getViewSize());
    }

    @Override
    public void webcamClosed(WebcamEvent we) {
        if (this.repainter != null) {
            if (this.repainter.isAlive()) {
                try {
                    this.repainter.join(1000L);
                }
                catch (InterruptedException e) {
                    throw new WebcamException("Thread interrupted", e);
                }
            }
            this.repainter = null;
        }
    }

    @Override
    public void webcamDisposed(WebcamEvent we) {
        this.webcamClosed(we);
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.starting = true;
            if (this.repainter == null) {
                this.repainter = new Repainter();
            }
            this.repainter.start();
            this.webcam.open();
            this.starting = false;
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.image = null;
            this.webcam.close();
        }
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFPS(double frequency) {
        if (frequency > 25.0) {
            frequency = 25.0;
        }
        if (frequency < 0.016) {
            frequency = 0.016;
        }
        this.frequency = frequency;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public void setFillArea(boolean fillArea) {
        this.fillArea = fillArea;
    }

    public boolean isFillArea() {
        return this.fillArea;
    }

    private class Repainter
    extends Thread {
        public Repainter() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (WebcamPanel.this.starting) {
                WebcamPanel.this.repaint();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOG.error("Nasty interrupted exception");
                }
            }
            if (!WebcamPanel.this.webcam.isOpen()) {
                WebcamPanel.this.webcam.open();
            }
            while (WebcamPanel.this.webcam.isOpen()) {
                BufferedImage tmp = WebcamPanel.this.webcam.getImage();
                try {
                    if (tmp == null) {
                        if (WebcamPanel.this.webcam.isOpen()) break;
                        LOG.error("Image is null");
                    } else {
                        WebcamPanel.this.image = tmp;
                        if (WebcamPanel.this.paused) {
                            Repainter repainter = this;
                            synchronized (repainter) {
                                this.wait();
                            }
                        }
                    }
                    Thread.sleep((long)(1000.0 / WebcamPanel.this.frequency));
                }
                catch (InterruptedException e) {
                    LOG.error("Nasty interrupted exception");
                }
                WebcamPanel.this.repaint();
            }
        }
    }

    public class DefaultPainter
    implements Painter {
        private String name = null;

        @Override
        public void paintPanel(WebcamPanel owner, Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(Color.BLACK);
            g2.fillRect(0, 0, WebcamPanel.this.getWidth(), WebcamPanel.this.getHeight());
            int cx = (WebcamPanel.this.getWidth() - 70) / 2;
            int cy = (WebcamPanel.this.getHeight() - 40) / 2;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRoundRect(cx, cy, 70, 40, 10, 10);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 5, cy + 5, 30, 30);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillOval(cx + 10, cy + 10, 20, 20);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 12, cy + 12, 16, 16);
            g2.fillRoundRect(cx + 50, cy + 5, 15, 10, 5, 5);
            g2.fillRect(cx + 63, cy + 25, 7, 2);
            g2.fillRect(cx + 63, cy + 28, 7, 2);
            g2.fillRect(cx + 63, cy + 31, 7, 2);
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, 0, WebcamPanel.this.getWidth(), WebcamPanel.this.getHeight());
            g2.drawLine(0, WebcamPanel.this.getHeight(), WebcamPanel.this.getWidth(), 0);
            String str = WebcamPanel.this.starting ? "Initializing" : "No Image";
            FontMetrics metrics = g2.getFontMetrics(WebcamPanel.this.getFont());
            int w = metrics.stringWidth(str);
            int h = metrics.getHeight();
            g2.setColor(Color.WHITE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.drawString(str, (WebcamPanel.this.getWidth() - w) / 2, cy - h);
            if (this.name == null) {
                this.name = WebcamPanel.this.webcam.getName();
            }
            str = this.name;
            w = metrics.stringWidth(str);
            h = metrics.getHeight();
            g2.drawString(str, (WebcamPanel.this.getWidth() - w) / 2, cy - 2 * h);
        }

        @Override
        public void paintImage(WebcamPanel owner, BufferedImage image, Graphics2D g2) {
            int w = WebcamPanel.this.getWidth();
            int h = WebcamPanel.this.getHeight();
            if (WebcamPanel.this.fillArea && image.getWidth() != w && image.getHeight() != h) {
                BufferedImage resized = new BufferedImage(w, h, 5);
                Graphics2D gr = resized.createGraphics();
                gr.setComposite(AlphaComposite.Src);
                gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gr.drawImage(image, 0, 0, w, h, null);
                gr.dispose();
                resized.flush();
                image = resized;
            }
            g2.drawImage((Image)image, 0, 0, null);
        }
    }

    public static interface Painter {
        public void paintPanel(WebcamPanel var1, Graphics2D var2);

        public void paintImage(WebcamPanel var1, BufferedImage var2, Graphics2D var3);
    }
}

