/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebcamProcessor {
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final ExecutorService runner = Executors.newSingleThreadExecutor(new ProcessorThreadFactory());
    private static final AtomicProcessor processor = new AtomicProcessor();

    public WebcamProcessor() {
        if (started.compareAndSet(false, true)) {
            runner.execute(processor);
        }
    }

    public void process(WebcamTask task) {
        try {
            processor.process(task);
        }
        catch (InterruptedException e) {
            throw new WebcamException("Processing interrupted", e);
        }
    }

    private static final class AtomicProcessor
    implements Runnable {
        private SynchronousQueue<WebcamTask> inbound = new SynchronousQueue(true);
        private SynchronousQueue<WebcamTask> outbound = new SynchronousQueue(true);

        private AtomicProcessor() {
        }

        public WebcamTask process(WebcamTask task) throws InterruptedException {
            this.inbound.put(task);
            return this.outbound.take();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WebcamTask t = null;
                try {
                    t = this.inbound.take();
                    t.handle();
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
                finally {
                    try {
                        if (t == null) continue;
                        this.outbound.put(t);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    continue;
                }
                break;
            }
        }
    }

    private static final class ProcessorThreadFactory
    implements ThreadFactory {
        private ProcessorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "atomic-processor");
            t.setDaemon(true);
            return t;
        }
    }
}

