/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamResolution;
import com.github.sarxos.webcam.ds.buildin.natives.Device;
import com.github.sarxos.webcam.ds.buildin.natives.OpenIMAJGrabber;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDefaultDevice
implements WebcamDevice {
    private static final Logger LOG;
    private static final Dimension[] DIMENSIONS;
    private static final int[] BAND_OFFSETS;
    private static final int[] BITS;
    private static final int[] OFFSET;
    private static final int DATA_TYPE = 0;
    private static final ColorSpace COLOR_SPACE;
    private OpenIMAJGrabber grabber = new OpenIMAJGrabber();
    private Device device = null;
    private Dimension size = null;
    private ComponentSampleModel sampleModel = null;
    private ColorModel colorModel = null;
    private boolean failOnSizeMismatch = false;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private AtomicBoolean open = new AtomicBoolean(false);
    private String name = null;
    private String id = null;
    private String fullname = null;

    protected WebcamDefaultDevice(Device device) {
        this.device = device;
        this.name = device.getNameStr();
        this.id = device.getIdentifierStr();
        this.fullname = String.format("%s %s", this.name, this.id);
    }

    @Override
    public String getName() {
        return this.fullname;
    }

    @Override
    public Dimension[] getResolutions() {
        return DIMENSIONS;
    }

    @Override
    public Dimension getResolution() {
        return this.size;
    }

    @Override
    public void setResolution(Dimension size) {
        if (this.open.get()) {
            throw new IllegalStateException("Cannot change resolution when webcam is open, please close it first");
        }
        this.size = size;
    }

    @Override
    public BufferedImage getImage() {
        if (this.disposed.get()) {
            LOG.debug("Webcam is disposed, image will be null");
            return null;
        }
        if (!this.open.get()) {
            LOG.debug("Webcam is closed, image will be null");
            return null;
        }
        LOG.trace("Webcam device get image (next frame)");
        this.grabber.nextFrame();
        Pointer<Byte> image = this.grabber.getImage();
        if (image == null) {
            LOG.warn("Null array pointer found instead of image");
            return null;
        }
        int length = this.size.width * this.size.height * 3;
        LOG.trace("Webcam device get image (transfer buffer) {} bytes", (Object)length);
        byte[] bytes = image.getBytes(length);
        byte[][] data = new byte[][]{bytes};
        if (bytes == null) {
            LOG.error("Images byte array is null!");
            return null;
        }
        DataBufferByte buffer = new DataBufferByte(data, bytes.length, OFFSET);
        WritableRaster raster = Raster.createWritableRaster(this.sampleModel, buffer, null);
        BufferedImage bi = new BufferedImage(this.colorModel, raster, false, null);
        bi.flush();
        return bi;
    }

    @Override
    public void open() {
        if (this.disposed.get()) {
            return;
        }
        LOG.debug("Opening webcam device {}", (Object)this.getName());
        if (this.size == null) {
            this.size = this.getResolutions()[0];
        }
        LOG.debug("Webcam device starting session, size {}", (Object)this.size);
        boolean started = this.grabber.startSession(this.size.width, this.size.height, 30.0, (Pointer<Device>)Pointer.pointerTo((NativeObject)this.device));
        if (!started) {
            throw new WebcamException("Cannot start native grabber!");
        }
        LOG.debug("Webcam device session started");
        Dimension size2 = new Dimension(this.grabber.getWidth(), this.grabber.getHeight());
        int w1 = this.size.width;
        int w2 = size2.width;
        int h1 = this.size.height;
        int h2 = size2.height;
        if (w1 != w2 || h1 != h2) {
            if (this.failOnSizeMismatch) {
                throw new WebcamException(String.format("Different size obtained vs requested - [%dx%d] vs [%dx%d]", w1, h1, w2, h2));
            }
            LOG.warn("Different size obtained vs requested - [{}x{}] vs [{}x{}]. Setting correct one. New size is [{}x{}]", new Object[]{w1, h1, w2, h2, w2, h2});
            this.size = new Dimension(w2, h2);
        }
        this.sampleModel = new ComponentSampleModel(0, this.size.width, this.size.height, 3, this.size.width * 3, BAND_OFFSETS);
        this.colorModel = new ComponentColorModel(COLOR_SPACE, BITS, false, false, 1, 0);
        LOG.debug("Initialize buffer");
        int i = 0;
        do {
            this.grabber.nextFrame();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("Nasty interrupted exception", (Throwable)e);
            }
        } while (++i < 3);
        LOG.debug("Webcam device is now open");
        this.open.set(true);
    }

    @Override
    public void close() {
        if (!this.open.compareAndSet(true, false)) {
            return;
        }
        LOG.debug("Closing webcam device");
        this.grabber.stopSession();
    }

    @Override
    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Disposing webcam device {}", (Object)this.getName());
        this.close();
    }

    public void setFailOnSizeMismatch(boolean fail) {
        this.failOnSizeMismatch = fail;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    static {
        if (!"true".equals(System.getProperty("webcam.debug"))) {
            System.setProperty("bridj.quiet", "true");
        }
        LOG = LoggerFactory.getLogger(WebcamDefaultDevice.class);
        DIMENSIONS = new Dimension[]{WebcamResolution.QQVGA.getSize(), WebcamResolution.QVGA.getSize(), WebcamResolution.CIF.getSize(), WebcamResolution.HVGA.getSize(), WebcamResolution.VGA.getSize(), WebcamResolution.XGA.getSize()};
        BAND_OFFSETS = new int[]{0, 1, 2};
        BITS = new int[]{8, 8, 8};
        OFFSET = new int[]{0};
        COLOR_SPACE = ColorSpace.getInstance(1000);
    }
}

