/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoverySupport;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.ds.buildin.WebcamDefaultDevice;
import com.github.sarxos.webcam.ds.buildin.natives.Device;
import com.github.sarxos.webcam.ds.buildin.natives.DeviceList;
import com.github.sarxos.webcam.ds.buildin.natives.OpenIMAJGrabber;
import java.util.ArrayList;
import java.util.List;
import org.bridj.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDefaultDriver
implements WebcamDriver,
WebcamDiscoverySupport {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDefaultDriver.class);
    private static final OpenIMAJGrabber GRABBER = new OpenIMAJGrabber();

    @Override
    public List<WebcamDevice> getDevices() {
        LOG.debug("Searching devices");
        ArrayList<WebcamDevice> devices = new ArrayList<WebcamDevice>();
        Pointer<DeviceList> pointer = GRABBER.getVideoDevices();
        DeviceList list = (DeviceList)((Object)pointer.get());
        for (Device device : list.asArrayList()) {
            devices.add(new WebcamDefaultDevice(device));
        }
        if (LOG.isDebugEnabled()) {
            for (WebcamDevice webcamDevice : devices) {
                LOG.debug("Found device {}", (Object)webcamDevice.getName());
            }
        }
        return devices;
    }

    @Override
    public long getScanInterval() {
        return 3000L;
    }

    @Override
    public boolean isScanPossible() {
        return true;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }
}

