/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.cgt;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamCloseTask
extends WebcamTask {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamCloseTask.class);
    private Webcam webcam = null;

    public WebcamCloseTask(Webcam webcam) {
        super(webcam);
    }

    public void close(Webcam webcam) {
        this.webcam = webcam;
        this.process();
    }

    @Override
    protected void handle() {
        WebcamDevice device = this.getDevice();
        if (!device.isOpen()) {
            return;
        }
        LOG.info("Closing {}", (Object)device.getName());
        device.close();
        WebcamEvent we = new WebcamEvent(this.webcam);
        for (WebcamListener l : this.webcam.getWebcamListeners()) {
            try {
                l.webcamClosed(we);
            }
            catch (Exception e) {
                LOG.error(String.format("Notify webcam closed, exception when calling %s listener", l.getClass()), (Throwable)e);
            }
        }
    }
}

