/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.cgt;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamOpenTask
extends WebcamTask {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamOpenTask.class);
    private Webcam webcam = null;

    public WebcamOpenTask(Webcam webcam) {
        super(webcam);
    }

    public void open(Webcam webcam) {
        this.webcam = webcam;
        this.process();
    }

    @Override
    protected void handle() {
        WebcamDevice device = this.getDevice();
        if (device.isOpen()) {
            return;
        }
        if (device.getResolution() == null) {
            device.setResolution(device.getResolutions()[0]);
        }
        LOG.info("Opening webcam {}", (Object)device.getName());
        device.open();
        WebcamEvent we = new WebcamEvent(this.webcam);
        for (WebcamListener l : this.webcam.getWebcamListeners()) {
            try {
                l.webcamOpen(we);
            }
            catch (Exception e) {
                LOG.error(String.format("Notify webcam open, exception when calling listener %s", l.getClass()), (Throwable)e);
            }
        }
    }
}

