/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import com.github.sarxos.webcam.WebcamException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final String FORMAT_GIF = "GIF";
    public static final String FORMAT_PNG = "PNG";
    public static final String FORMAT_JPG = "JPG";
    public static final String FORMAT_BMP = "BMP";
    public static final String FORMAT_WBMP = "WBMP";

    public static BufferedImage premultiple(BufferedImage src) {
        BufferedImage pre = new BufferedImage(512, 512, 3);
        Graphics2D g2 = pre.createGraphics();
        g2.drawImage((Image)src, 0, 0, null);
        g2.dispose();
        pre.flush();
        return pre;
    }

    public static BufferedImage unpremultiple(BufferedImage pre) {
        BufferedImage src = new BufferedImage(512, 512, 2);
        Graphics2D g2 = pre.createGraphics();
        g2.drawImage((Image)src, 0, 0, null);
        g2.dispose();
        src.flush();
        return src;
    }

    public static byte[] toByteArray(BufferedImage image, String format) {
        byte[] bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, baos);
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new WebcamException(e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new WebcamException(e);
            }
        }
        return bytes;
    }
}

