/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.LineRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EmptyLines
extends LineRule {
    public static final String OPTION_MAX = "max";
    public static final String OPTION_MAX_START = "max-start";
    public static final String OPTION_MAX_END = "max-end";

    public EmptyLines() {
        this.options.put(OPTION_MAX, Integer.class);
        this.options.put(OPTION_MAX_START, Integer.class);
        this.options.put(OPTION_MAX_END, Integer.class);
    }

    @Override
    public List<LintProblem> check(Map conf, Parser.Line line) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        Parser.Line newLine = Parser.getLines(line.getBuffer().replaceAll("\r\n", "\n")).get(line.getLineNo() - 1);
        if (newLine.getStart() == newLine.getEnd() && newLine.getEnd() < newLine.getBuffer().length()) {
            int blankLines;
            if (newLine.getEnd() < newLine.getBuffer().length() - 1 && newLine.getBuffer().charAt(newLine.getEnd() + 1) == '\n') {
                return problems;
            }
            for (blankLines = 0; newLine.getStart() > blankLines && newLine.getBuffer().charAt(newLine.getStart() - blankLines - 1) == '\n'; ++blankLines) {
            }
            int max = (Integer)conf.get(OPTION_MAX);
            if (newLine.getStart() - blankLines == 0) {
                ++blankLines;
                max = (Integer)conf.get(OPTION_MAX_START);
            }
            if (newLine.getEnd() == newLine.getBuffer().length() - 1 && (newLine.getBuffer().charAt(newLine.getEnd()) == '\n' || newLine.getBuffer().charAt(newLine.getEnd()) == '\r')) {
                if (newLine.getEnd() == 0) {
                    return problems;
                }
                max = (Integer)conf.get(OPTION_MAX_END);
            }
            if (blankLines > max) {
                problems.add(new LintProblem(newLine.getLineNo(), 1, "too many blank lines (" + blankLines + " > " + max + ")"));
            }
        }
        return problems;
    }
}

