/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

public class EmptyValues
extends TokenRule {
    public static final String OPTION_FORBID_IN_BLOCK_MAPPINGS = "forbid-in-block-mappings";
    public static final String OPTION_FORBID_IN_FLOW_MAPPINGS = "forbid-in-flow-mappings";

    public EmptyValues() {
        this.options.put(OPTION_FORBID_IN_BLOCK_MAPPINGS, Boolean.class);
        this.options.put(OPTION_FORBID_IN_FLOW_MAPPINGS, Boolean.class);
    }

    @Override
    public List<LintProblem> check(Map conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (((Boolean)conf.get(OPTION_FORBID_IN_BLOCK_MAPPINGS)).booleanValue() && token instanceof ValueToken && (next instanceof KeyToken || next instanceof BlockEndToken)) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getEndMark().getColumn() + 1, "empty value in block mapping"));
        }
        if (((Boolean)conf.get(OPTION_FORBID_IN_FLOW_MAPPINGS)).booleanValue() && token instanceof ValueToken && (next instanceof FlowEntryToken || next instanceof FlowMappingEndToken)) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getEndMark().getColumn() + 1, "empty value in flow mapping"));
        }
        return problems;
    }
}

