/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

public class Indentation
extends TokenRule {
    public static final String STACK_KEY = "stack";
    private static final String CURRENT_LINE_KEY = "cur_line";
    private static final String CURRENT_LINE_INDENT_KEY = "cur_line_indent";
    public static final String OPTION_SPACES = "spaces";
    public static final String OPTION_CONSISTENT = "consistent";
    public static final String OPTION_INDENT_SEQUENCES = "indent-sequences";
    public static final String OPTION_CHECK_MULTI_LINE_STRINGS = "check-multi-line-strings";

    public Indentation() {
        this.options.put(OPTION_SPACES, Arrays.asList(Integer.class, OPTION_CONSISTENT));
        this.options.put(OPTION_INDENT_SEQUENCES, Arrays.asList(Boolean.class, "whatever", OPTION_CONSISTENT));
        this.options.put(OPTION_CHECK_MULTI_LINE_STRINGS, Boolean.class);
    }

    @Override
    public List<LintProblem> check(Map conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        try {
            problems.addAll(this.checkToken(conf, token, prev, next, nextnext, context));
        }
        catch (AssertionError e) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, "cannot infer indentation: unexpected token"));
        }
        return problems;
    }

    private int detectIndent(int baseIndent, int foundIndent, Map context) {
        if (!(context.get(OPTION_SPACES) instanceof Integer)) {
            context.put(OPTION_SPACES, foundIndent - baseIndent);
        }
        return baseIndent + (Integer)context.get(OPTION_SPACES);
    }

    private int computeExpectedIndent(int foundIndent, Token token, Map context) {
        Boolean plain = (Boolean)this.invokeSimpleMethod(token, "getPlain");
        DumperOptions.ScalarStyle style = (DumperOptions.ScalarStyle)this.invokeSimpleMethod(token, "getStyle");
        if (plain != null && plain.booleanValue()) {
            return token.getStartMark().getColumn();
        }
        if (style != null && (style.getChar().charValue() == '\"' || style.getChar().charValue() == '\'')) {
            return token.getStartMark().getColumn() + 1;
        }
        if (style != null && (style.getChar().charValue() == '>' || style.getChar().charValue() == '|')) {
            List stack = (List)context.get(STACK_KEY);
            if (((Parent)stack.get(stack.size() - 1)).type == LABEL.B_ENT) {
                return this.detectIndent(token.getStartMark().getColumn(), foundIndent, context);
            }
            if (((Parent)stack.get(stack.size() - 1)).type == LABEL.KEY) {
                assert (((Parent)stack.get(stack.size() - 1)).explicitKey);
                return this.detectIndent(token.getStartMark().getColumn(), foundIndent, context);
            }
            if (((Parent)stack.get(stack.size() - 1)).type == LABEL.VAL) {
                if (token.getStartMark().getLine() + 1 > (Integer)context.get(CURRENT_LINE_KEY)) {
                    return this.detectIndent((int)((Parent)stack.get(stack.size() - 1)).indent, foundIndent, context);
                }
                if (((Parent)stack.get(stack.size() - 2)).explicitKey) {
                    return this.detectIndent(token.getStartMark().getColumn(), foundIndent, context);
                }
                return this.detectIndent((int)((Parent)stack.get(stack.size() - 2)).indent, foundIndent, context);
            }
            return this.detectIndent((int)((Parent)stack.get(stack.size() - 1)).indent, foundIndent, context);
        }
        return 0;
    }

    private Object invokeSimpleMethod(Object o, String methodName) {
        try {
            return o.getClass().getMethod(methodName, null).invoke(o, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private List<LintProblem> checkScalarIndentation(Token token, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (token.getStartMark().getLine() == token.getEndMark().getLine()) {
            return problems;
        }
        int expectedIndent = -1;
        int lineNo = token.getStartMark().getLine() + 1;
        int lineStart = token.getStartMark().getPointer();
        while ((lineStart = this.find(token.getStartMark().getBuffer(), 10, lineStart, token.getEndMark().getPointer() - 1) + 1) != 0) {
            ++lineNo;
            int indent = 0;
            while (token.getStartMark().getBuffer()[lineStart + indent] == 32) {
                ++indent;
            }
            if (token.getStartMark().getBuffer()[lineStart + indent] == 10) continue;
            if (expectedIndent == -1) {
                expectedIndent = this.computeExpectedIndent(indent, token, context);
            }
            if (indent == expectedIndent) continue;
            problems.add(new LintProblem(lineNo, indent + 1, "wrong indentation: expected " + expectedIndent + " but found " + indent));
        }
        return problems;
    }

    private List<LintProblem> checkToken(Map conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (!context.containsKey(STACK_KEY)) {
            context.put(STACK_KEY, new ArrayList<Parent>(Arrays.asList(new Parent(LABEL.ROOT, 0))));
            context.put(CURRENT_LINE_KEY, -1);
            context.put(OPTION_SPACES, conf.get(OPTION_SPACES));
            context.put(OPTION_INDENT_SEQUENCES, conf.get(OPTION_INDENT_SEQUENCES));
        }
        List stack = (List)context.get(STACK_KEY);
        boolean isVisible = !(token instanceof StreamStartToken) && !(token instanceof StreamEndToken) && !(token instanceof BlockEndToken) && (!(token instanceof ScalarToken) || !"".equals(this.invokeSimpleMethod(token, "getValue")));
        boolean firstInLine = isVisible && token.getStartMark().getLine() + 1 > (Integer)context.get(CURRENT_LINE_KEY);
        Integer foundIndentation = null;
        if (firstInLine) {
            foundIndentation = token.getStartMark().getColumn();
            int expected = ((Parent)stack.get(stack.size() - 1)).indent;
            if (token instanceof FlowMappingEndToken || token instanceof FlowSequenceEndToken) {
                expected = ((Parent)stack.get(stack.size() - 1)).lineIndent;
            } else if (((Parent)stack.get(stack.size() - 1)).type == LABEL.KEY && ((Parent)stack.get(stack.size() - 1)).explicitKey && !(token instanceof ValueToken)) {
                expected = this.detectIndent(expected, token, context);
            }
            if (foundIndentation != expected) {
                problems.add(new LintProblem(token.getStartMark().getLine() + 1, foundIndentation + 1, "wrong indentation: expected " + expected + " but found " + foundIndentation));
            }
        }
        if (token instanceof ScalarToken && ((Boolean)conf.get(OPTION_CHECK_MULTI_LINE_STRINGS)).booleanValue()) {
            problems.addAll(this.checkScalarIndentation(token, context));
        }
        if (isVisible) {
            context.put(CURRENT_LINE_KEY, this.getRealEndLine(token));
            if (firstInLine) {
                context.put(CURRENT_LINE_INDENT_KEY, foundIndentation);
            }
        }
        Integer indent = null;
        if (token instanceof BlockMappingStartToken) {
            assert (next instanceof KeyToken);
            assert (next.getStartMark().getLine() == token.getStartMark().getLine());
            indent = token.getStartMark().getColumn();
            stack.add(new Parent(LABEL.B_MAP, indent));
        } else if (token instanceof FlowMappingStartToken) {
            indent = next.getStartMark().getLine() == token.getStartMark().getLine() ? Integer.valueOf(next.getStartMark().getColumn()) : Integer.valueOf(this.detectIndent((int)((Integer)context.get(CURRENT_LINE_INDENT_KEY)), next, context));
            stack.add(new Parent(LABEL.F_MAP, indent, (int)((Integer)context.get(CURRENT_LINE_INDENT_KEY))));
        } else if (token instanceof BlockSequenceStartToken) {
            assert (next instanceof BlockEntryToken);
            assert (next.getStartMark().getLine() == token.getStartMark().getLine());
            indent = token.getStartMark().getColumn();
            stack.add(new Parent(LABEL.B_SEQ, indent));
        } else if (token instanceof BlockEntryToken && !(next instanceof BlockEntryToken) && !(next instanceof BlockEndToken)) {
            if (((Parent)stack.get(stack.size() - 1)).type != LABEL.B_SEQ) {
                stack.add(new Parent(LABEL.B_SEQ, token.getStartMark().getColumn()));
                ((Parent)stack.get(stack.size() - 1)).implicitBlockSeq = true;
            }
            indent = next.getStartMark().getLine() == token.getEndMark().getLine() ? Integer.valueOf(next.getStartMark().getColumn()) : (next.getStartMark().getColumn() == token.getStartMark().getColumn() ? Integer.valueOf(next.getStartMark().getColumn()) : Integer.valueOf(this.detectIndent(token.getStartMark().getColumn(), next, context)));
            stack.add(new Parent(LABEL.B_ENT, indent));
        } else if (token instanceof FlowSequenceStartToken) {
            indent = next.getStartMark().getLine() == token.getStartMark().getLine() ? Integer.valueOf(next.getStartMark().getColumn()) : Integer.valueOf(this.detectIndent((int)((Integer)context.get(CURRENT_LINE_INDENT_KEY)), next, context));
            stack.add(new Parent(LABEL.F_SEQ, indent, (int)((Integer)context.get(CURRENT_LINE_INDENT_KEY))));
        } else if (token instanceof KeyToken) {
            indent = ((Parent)stack.get(stack.size() - 1)).indent;
            stack.add(new Parent(LABEL.KEY, indent));
            ((Parent)stack.get(stack.size() - 1)).explicitKey = this.isExplicitKey(token);
        } else if (token instanceof ValueToken) {
            assert (((Parent)stack.get(stack.size() - 1)).type == LABEL.KEY);
            if ((next instanceof AnchorToken || next instanceof TagToken) && next.getStartMark().getLine() == prev.getStartMark().getLine() && next.getStartMark().getLine() < nextnext.getStartMark().getLine()) {
                next = nextnext;
            }
            if (!(next instanceof BlockEndToken || next instanceof FlowMappingEndToken || next instanceof FlowSequenceEndToken || next instanceof KeyToken)) {
                if (((Parent)stack.get(stack.size() - 1)).explicitKey) {
                    indent = this.detectIndent((int)((Parent)stack.get(stack.size() - 1)).indent, next, context);
                } else if (next.getStartMark().getLine() == prev.getStartMark().getLine()) {
                    indent = next.getStartMark().getColumn();
                } else if (next instanceof BlockSequenceStartToken || next instanceof BlockEntryToken) {
                    if (context.get(OPTION_INDENT_SEQUENCES) instanceof Boolean && !((Boolean)context.get(OPTION_INDENT_SEQUENCES)).booleanValue()) {
                        indent = ((Parent)stack.get(stack.size() - 1)).indent;
                    } else if (context.get(OPTION_INDENT_SEQUENCES) instanceof Boolean && ((Boolean)context.get(OPTION_INDENT_SEQUENCES)).booleanValue()) {
                        indent = OPTION_CONSISTENT.equals(context.get(OPTION_SPACES)) && next.getStartMark().getColumn() - ((Parent)stack.get(stack.size() - 1)).indent == 0 ? Integer.valueOf(2) : Integer.valueOf(this.detectIndent((int)((Parent)stack.get(stack.size() - 1)).indent, next, context));
                    } else if (next.getStartMark().getColumn() == ((Parent)stack.get(stack.size() - 1)).indent.intValue()) {
                        if (OPTION_CONSISTENT.equals(context.get(OPTION_INDENT_SEQUENCES))) {
                            context.put(OPTION_INDENT_SEQUENCES, false);
                        }
                        indent = ((Parent)stack.get(stack.size() - 1)).indent;
                    } else {
                        if (OPTION_CONSISTENT.equals(context.get(OPTION_INDENT_SEQUENCES))) {
                            context.put(OPTION_INDENT_SEQUENCES, true);
                        }
                        indent = this.detectIndent((int)((Parent)stack.get(stack.size() - 1)).indent, next, context);
                    }
                } else {
                    indent = this.detectIndent((int)((Parent)stack.get(stack.size() - 1)).indent, next, context);
                }
                stack.add(new Parent(LABEL.VAL, indent));
            }
        }
        boolean consumedCurrentToken = false;
        while (true) {
            if (((Parent)stack.get(stack.size() - 1)).type == LABEL.F_SEQ && token instanceof FlowSequenceEndToken && !consumedCurrentToken || ((Parent)stack.get(stack.size() - 1)).type == LABEL.F_MAP && token instanceof FlowMappingEndToken && !consumedCurrentToken || (((Parent)stack.get(stack.size() - 1)).type == LABEL.B_MAP || ((Parent)stack.get(stack.size() - 1)).type == LABEL.B_SEQ) && token instanceof BlockEndToken && !((Parent)stack.get(stack.size() - 1)).implicitBlockSeq && !consumedCurrentToken) {
                stack.remove(stack.size() - 1);
                consumedCurrentToken = true;
                continue;
            }
            if (!(((Parent)stack.get(stack.size() - 1)).type != LABEL.B_ENT || token instanceof BlockEntryToken || !((Parent)stack.get(stack.size() - 2)).implicitBlockSeq || token instanceof AnchorToken || token instanceof TagToken || next instanceof BlockEntryToken)) {
                stack.remove(stack.size() - 1);
                stack.remove(stack.size() - 1);
                continue;
            }
            if (((Parent)stack.get(stack.size() - 1)).type == LABEL.B_ENT && (next instanceof BlockEntryToken || next instanceof BlockEndToken)) {
                stack.remove(stack.size() - 1);
                continue;
            }
            if (!(((Parent)stack.get(stack.size() - 1)).type != LABEL.VAL || token instanceof ValueToken || token instanceof AnchorToken || token instanceof TagToken)) {
                assert (((Parent)stack.get(stack.size() - 2)).type == LABEL.KEY);
                stack.remove(stack.size() - 1);
                stack.remove(stack.size() - 1);
                continue;
            }
            if (((Parent)stack.get(stack.size() - 1)).type != LABEL.KEY || !(next instanceof BlockEndToken) && !(next instanceof FlowMappingEndToken) && !(next instanceof FlowSequenceEndToken) && !(next instanceof KeyToken)) break;
            stack.remove(stack.size() - 1);
        }
        return problems;
    }

    private int detectIndent(int baseIndent, Token next, Map context) {
        if (!(context.get(OPTION_SPACES) instanceof Integer)) {
            context.put(OPTION_SPACES, next.getStartMark().getColumn() - baseIndent);
        }
        return baseIndent + (Integer)context.get(OPTION_SPACES);
    }

    public class Parent {
        private LABEL type;
        private Integer indent;
        private Integer lineIndent;
        private boolean explicitKey;
        private boolean implicitBlockSeq;

        public Parent(LABEL type, int indent) {
            this(type, indent, null);
        }

        public Parent(LABEL type, int indent, Integer lineIndent) {
            this.type = type;
            this.indent = indent;
            this.lineIndent = lineIndent;
            this.explicitKey = false;
            this.implicitBlockSeq = false;
        }

        public String toString() {
            return String.format("%1$s:%2$d", new Object[]{this.type, this.indent});
        }
    }

    public static enum LABEL {
        ROOT,
        B_MAP,
        F_MAP,
        B_SEQ,
        F_SEQ,
        B_ENT,
        KEY,
        VAL;

    }
}

