/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.CommentRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;

public class CommentsIndentation
extends CommentRule {
    @Override
    public List<LintProblem> check(Map conf, Parser.Comment comment) {
        int prevLineIndent;
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (!(comment.getTokenBefore() instanceof StreamStartToken) && comment.getTokenBefore().getEndMark().getLine() + 1 == comment.getLineNo()) {
            return problems;
        }
        int nextLineIndent = comment.getTokenAfter().getStartMark().getColumn();
        if (comment.getTokenAfter() instanceof StreamEndToken) {
            nextLineIndent = 0;
        }
        if ((prevLineIndent = comment.getTokenBefore() instanceof StreamStartToken ? 0 : this.getLineIndent(comment.getTokenBefore())) <= nextLineIndent) {
            prevLineIndent = nextLineIndent;
        }
        if (comment.getCommentBefore() != null && !comment.getCommentBefore().isInline()) {
            prevLineIndent = comment.getCommentBefore().getColumnNo() - 1;
        }
        if (comment.getColumnNo() - 1 != prevLineIndent && comment.getColumnNo() - 1 != nextLineIndent) {
            problems.add(new LintProblem(comment.getLineNo(), comment.getColumnNo(), "comment not indented like content"));
        }
        return problems;
    }
}

