/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

public class QuotedStrings
extends TokenRule {
    public static final String OPTION_QUOTE_TYPE = "quote-type";
    public static final String QUOTE_STYLE_SINGLE = "single";
    public static final String QUOTE_STYLE_DOUBLE = "double";
    public static final String QUOTE_STYLE_ANY = "any";

    public QuotedStrings() {
        this.options.put(OPTION_QUOTE_TYPE, Arrays.asList(QUOTE_STYLE_SINGLE, QUOTE_STYLE_DOUBLE, QUOTE_STYLE_ANY));
    }

    @Override
    public List<LintProblem> check(Map conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        String quoteType = conf.getOrDefault(OPTION_QUOTE_TYPE, QUOTE_STYLE_ANY);
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (token instanceof ScalarToken && (prev instanceof ValueToken || prev instanceof TagToken)) {
            if (prev instanceof TagToken && "!!".equals(((TagToken)prev).getValue().getHandle())) {
                return problems;
            }
            Resolver resolver = new Resolver();
            if (resolver.resolve(NodeId.scalar, ((ScalarToken)token).getValue(), true) != Tag.STR) {
                return problems;
            }
            if (!(((ScalarToken)token).getPlain() || ((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.LITERAL && ((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.FOLDED)) {
                return problems;
            }
            if (quoteType.equals(QUOTE_STYLE_SINGLE) && ((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.SINGLE_QUOTED || quoteType.equals(QUOTE_STYLE_DOUBLE) && ((ScalarToken)token).getStyle() != DumperOptions.ScalarStyle.DOUBLE_QUOTED || quoteType.equals(QUOTE_STYLE_ANY) && ((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.PLAIN) {
                problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, "string value is not quoted with " + quoteType + " quotes"));
            }
        }
        return problems;
    }
}

