/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.rules.CommentRule;
import com.github.sbaudoin.yamllint.rules.LineRule;
import com.github.sbaudoin.yamllint.rules.Rule;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class Linter {
    private static final String RULE_TOKEN = "rule:";
    public static final String LEVEL_KEY = "level";
    public static final String NONE_LEVEL = "none";
    public static final String INFO_LEVEL = "info";
    public static final String WARNING_LEVEL = "warning";
    public static final String ERROR_LEVEL = "error";
    private static final Map<Object, Object> PROBLEM_LEVELS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Integer, String>(0, "none"), new AbstractMap.SimpleEntry<String, Integer>("none", 0), new AbstractMap.SimpleEntry<Integer, String>(1, "info"), new AbstractMap.SimpleEntry<String, Integer>("info", 1), new AbstractMap.SimpleEntry<Integer, String>(2, "warning"), new AbstractMap.SimpleEntry<String, Integer>("warning", 2), new AbstractMap.SimpleEntry<Integer, String>(3, "error"), new AbstractMap.SimpleEntry<String, Integer>("error", 3)).collect(Collectors.toMap(e -> (Serializable)e.getKey(), e -> (Serializable)e.getValue())));

    private Linter() {
    }

    public static List<LintProblem> run(String buffer, YamlLintConfig conf) {
        return Linter.run(buffer, conf, null);
    }

    public static List<LintProblem> run(YamlLintConfig conf, File file) throws IOException {
        if (conf.isFileIgnored(file.getPath())) {
            return new ArrayList<LintProblem>();
        }
        return Linter.run(new String(Files.readAllBytes(file.toPath())), conf, file);
    }

    public static List<LintProblem> run(String buffer, YamlLintConfig conf, File file) {
        LinkedHashSet<LintProblem> problems = new LinkedHashSet<LintProblem>();
        LintProblem syntaxError = Linter.getSyntaxError(buffer);
        for (LintProblem problem : Linter.getCosmeticProblems(buffer, conf, file)) {
            if (syntaxError != null && syntaxError.getLine() <= problem.getLine() && syntaxError.getColumn() <= problem.getColumn()) {
                problems.add(syntaxError);
                if (syntaxError.getLine() == problem.getLine() && syntaxError.getColumn() == problem.getColumn()) {
                    syntaxError = null;
                    continue;
                }
            }
            problems.add(problem);
        }
        if (syntaxError != null) {
            problems.add(syntaxError);
        }
        return new ArrayList<LintProblem>(problems);
    }

    public static Object getProblemLevel(Object key) {
        return PROBLEM_LEVELS.get(key);
    }

    public static LintProblem getSyntaxError(String buffer) {
        try {
            new Yaml().parse((Reader)new StringReader(buffer)).forEach(o -> {});
        }
        catch (MarkedYAMLException e) {
            LintProblem problem = new LintProblem(e.getProblemMark().getLine() + 1, e.getProblemMark().getColumn() + 1, "syntax error: " + e.getProblem());
            problem.setLevel(ERROR_LEVEL);
            return problem;
        }
        return null;
    }

    public static List<LintProblem> getCosmeticProblems(String buffer, YamlLintConfig conf, @Nullable File file) {
        List<Rule> rules = conf.getEnabledRules(file);
        List tokenRules = rules.stream().filter(rule -> rule.getType() == Rule.TYPE.TOKEN).collect(Collectors.toList());
        List commentRules = rules.stream().filter(rule -> rule.getType() == Rule.TYPE.COMMENT).collect(Collectors.toList());
        List lineRules = rules.stream().filter(rule -> rule.getType() == Rule.TYPE.LINE).collect(Collectors.toList());
        HashMap context = new HashMap();
        for (Rule rule2 : tokenRules) {
            context.put(rule2.getId(), new HashMap());
        }
        ArrayList<LintProblem> cache = new ArrayList<LintProblem>();
        DisableDirective disabled = new DisableDirective(rules);
        DisableLineDirective disabledForLine = new DisableLineDirective(rules);
        DisableLineDirective disabledForNextLine = new DisableLineDirective(rules);
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        List<Parser.Lined> items = Parser.getTokensOrCommentsOrLines(buffer);
        for (Parser.Lined elem : items) {
            Map ruleConf;
            if (elem instanceof Parser.Token) {
                for (Rule rule3 : tokenRules) {
                    ruleConf = (Map)conf.getRuleConf(rule3.getId());
                    for (LintProblem problem : ((TokenRule)rule3).check(ruleConf, ((Parser.Token)elem).getCurr(), ((Parser.Token)elem).getPrev(), ((Parser.Token)elem).getNext(), ((Parser.Token)elem).getNextNext(), (Map)context.get(rule3.getId()))) {
                        problem.setRuleId(rule3.getId());
                        problem.setLevel((String)ruleConf.get(LEVEL_KEY));
                        cache.add(problem);
                    }
                }
                continue;
            }
            if (elem instanceof Parser.Comment) {
                for (Rule rule3 : commentRules) {
                    ruleConf = (Map)conf.getRuleConf(rule3.getId());
                    for (LintProblem problem : ((CommentRule)rule3).check(ruleConf, (Parser.Comment)elem)) {
                        problem.setRuleId(rule3.getId());
                        problem.setLevel((String)ruleConf.get(LEVEL_KEY));
                        cache.add(problem);
                    }
                }
                disabled.processComment((Parser.Comment)elem);
                if (((Parser.Comment)elem).isInline()) {
                    disabledForLine.processComment((Parser.Comment)elem);
                    continue;
                }
                disabledForNextLine.processComment((Parser.Comment)elem);
                continue;
            }
            if (!(elem instanceof Parser.Line)) continue;
            for (Rule rule3 : lineRules) {
                ruleConf = (Map)conf.getRuleConf(rule3.getId());
                for (LintProblem problem : ((LineRule)rule3).check(ruleConf, (Parser.Line)elem)) {
                    problem.setRuleId(rule3.getId());
                    problem.setLevel((String)ruleConf.get(LEVEL_KEY));
                    cache.add(problem);
                }
            }
            for (LintProblem problem : cache) {
                if (disabledForLine.isDisabledByDirective(problem) || disabled.isDisabledByDirective(problem)) continue;
                problems.add(problem);
            }
            disabledForLine = disabledForNextLine;
            disabledForNextLine = new DisableLineDirective(rules);
            cache.clear();
        }
        return problems;
    }

    private static class DisableLineDirective
    extends DisableDirective {
        public DisableLineDirective(List<Rule> rules) {
            super(rules);
        }

        @Override
        public void processComment(Parser.Comment token) {
            String comment = token.toString();
            Matcher disableMatcher = Pattern.compile("# yamllint disable-line(( rule:\\S+)*)\\s*$").matcher(comment);
            if (disableMatcher.find()) {
                String[] cRules = disableMatcher.group(1).trim().replaceAll(Linter.RULE_TOKEN, "").split(" ");
                if (cRules.length == 0 || "".equals(cRules[0])) {
                    this.rules = new ArrayList(this.allRules);
                } else {
                    for (String id : cRules) {
                        if (!this.allRules.contains(id)) continue;
                        this.rules.add(id);
                    }
                }
            }
        }
    }

    private static class DisableDirective {
        protected List<String> rules = new ArrayList<String>();
        protected List<String> allRules = new ArrayList<String>();

        DisableDirective(List<Rule> rules) {
            rules.forEach(rule -> this.allRules.add(rule.getId()));
        }

        public void processComment(Parser.Comment token) {
            block7: {
                Matcher enableMatcher;
                block6: {
                    String comment = token.toString();
                    Matcher disableMatcher = Pattern.compile("# yamllint disable(( rule:\\S+)*)\\s*$").matcher(comment);
                    enableMatcher = Pattern.compile("# yamllint enable(( rule:\\S+)*)\\s*$").matcher(comment);
                    if (!disableMatcher.find()) break block6;
                    String[] cRules = disableMatcher.group(1).trim().replaceAll(Linter.RULE_TOKEN, "").split(" ");
                    if (cRules.length == 0 || "".equals(cRules[0])) {
                        this.rules = new ArrayList<String>(this.allRules);
                    } else {
                        for (String id : cRules) {
                            if (!this.allRules.contains(id)) continue;
                            this.rules.add(id);
                        }
                    }
                    break block7;
                }
                if (!enableMatcher.find()) break block7;
                String[] cRules = enableMatcher.group(1).trim().replaceAll(Linter.RULE_TOKEN, "").split(" ");
                if (cRules.length == 0 || "".equals(cRules[0])) {
                    this.rules.clear();
                } else {
                    for (String id : cRules) {
                        this.rules.remove(id);
                    }
                }
            }
        }

        public boolean isDisabledByDirective(LintProblem problem) {
            return this.rules.contains(problem.getRuleId());
        }
    }
}

