/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.Format;
import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Linter;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.YamlLintConfigException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Cli {
    public static final String FORMAT_PARSABLE = "parsable";
    public static final String FORMAT_STANDARD = "standard";
    public static final String APP_NAME = "yamllint";
    public static final String USER_CONF_FILENAME = ".yamllint";
    private static final String ARG_FILES_OR_DIR = "FILES_OR_DIR";
    private static final String ARG_CONFIG_FILE = "config_file";
    private static final String ARG_CONFIG_DATA = "config_data";
    private static final String ARG_FORMAT = "format";
    private static final String ARG_STRICT = "strict";
    private static final String ARG_VERSION = "version";
    private static final String ARG_HELP = "help";
    private OutputStream stdout = System.out;
    private OutputStream errout = System.err;
    private YamlLintConfig conf;

    public static void main(String[] args) {
        new Cli().run(args);
    }

    public void setStdOutputStream(OutputStream out) {
        this.stdout = out;
    }

    public void setErrOutputStream(OutputStream out) {
        this.errout = out;
    }

    public void run(String[] args) {
        Map<String, Object> arguments = this.getCommandLineArguments(args);
        try {
            this.getYamlLintConfig(arguments);
        }
        catch (Exception e) {
            this.endOnError("cannot get or process configuration: " + e.getMessage(), null);
        }
        int maxLevel = 0;
        for (File file : this.findFilesRecursively((String[])arguments.get(ARG_FILES_OR_DIR))) {
            boolean first = true;
            try {
                for (LintProblem problem : Linter.run(this.conf, file)) {
                    if (FORMAT_PARSABLE.equals(arguments.get(ARG_FORMAT))) {
                        this.out(Format.parsable(problem, file.getPath()));
                    } else if (Format.supportsColor()) {
                        if (first) {
                            this.out("\u001b[4m" + file.getPath() + "\u001b[0m");
                            first = false;
                        }
                        this.out(Format.standardColor(problem));
                    } else {
                        if (first) {
                            this.out(file.getPath());
                            first = false;
                        }
                        this.out(Format.standard(problem));
                    }
                    maxLevel = Math.max(maxLevel, (Integer)Linter.getProblemLevel(problem.getLevel()));
                }
            }
            catch (IOException e) {
                this.err("Cannot read file `" + file.getPath() + "', skipping");
            }
            if (first || FORMAT_PARSABLE.equals(arguments.get(ARG_FORMAT))) continue;
            this.out("");
        }
        if (maxLevel == (Integer)Linter.getProblemLevel("error")) {
            System.exit(1);
        } else if (maxLevel == (Integer)Linter.getProblemLevel("warning") && Boolean.TRUE.equals(arguments.get(ARG_STRICT))) {
            System.exit(2);
        }
    }

    private Map<String, Object> getCommandLineArguments(String[] args) {
        CommandLine cmdLine = this.parseCommandLine(this.prepareOptions(), args);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(ARG_CONFIG_FILE, cmdLine.getOptionValue('c'));
        arguments.put(ARG_CONFIG_DATA, cmdLine.getOptionValue('d'));
        arguments.put(ARG_FORMAT, cmdLine.getOptionValue('f', FORMAT_STANDARD));
        arguments.put(ARG_STRICT, cmdLine.hasOption('s'));
        arguments.put(ARG_FILES_OR_DIR, cmdLine.getArgs());
        return arguments;
    }

    private Options prepareOptions() {
        Options options = new Options();
        OptionGroup og = new OptionGroup();
        options.addOption(Option.builder((String)"h").longOpt(ARG_HELP).hasArg(false).argName(ARG_HELP).desc("show this help message and exit").build());
        options.addOption(Option.builder((String)"v").longOpt(ARG_VERSION).hasArg(false).argName(ARG_VERSION).desc("show program's version number and exit").build());
        og.addOption(Option.builder((String)"c").longOpt("config-file").hasArg().argName(ARG_CONFIG_FILE).desc("path to a custom configuration").build());
        og.addOption(Option.builder((String)"d").longOpt("config-data").hasArg().argName(ARG_CONFIG_DATA).desc("custom configuration (as YAML source)").build());
        options.addOptionGroup(og);
        options.addOption(Option.builder((String)"f").longOpt(ARG_FORMAT).hasArg().argName(ARG_FORMAT).desc("format for parsing output: `parsable' or `standard' (default)").build());
        options.addOption(Option.builder((String)"s").longOpt(ARG_STRICT).hasArg(false).argName(ARG_STRICT).desc("return non-zero exit code on warnings as well as errors").build());
        return options;
    }

    private CommandLine parseCommandLine(Options options, String[] args) {
        DefaultParser cmdParser = new DefaultParser();
        CommandLine cmdLine = null;
        try {
            String format;
            cmdLine = cmdParser.parse(options, args);
            if (cmdLine.hasOption(ARG_HELP)) {
                this.showHelpAndExit(options);
            }
            if (cmdLine.hasOption(ARG_VERSION)) {
                Properties props = new Properties();
                props.load(Cli.class.getClassLoader().getResourceAsStream("yaml.properties"));
                this.err("yamllint " + props.getProperty(ARG_VERSION));
                System.exit(1);
            }
            if (!FORMAT_STANDARD.equals(format = cmdLine.getOptionValue(ARG_FORMAT, FORMAT_STANDARD)) && !FORMAT_PARSABLE.equals(format)) {
                this.endOnError("invalid output format", options);
            }
        }
        catch (AlreadySelectedException e) {
            this.endOnError("options `c' and `d' are mutually exclusive.\n", options);
        }
        catch (IOException | ParseException e) {
            this.endOnError(e.getMessage(), options);
        }
        return cmdLine;
    }

    private void getYamlLintConfig(Map<String, Object> arguments) throws IOException, YamlLintConfigException {
        Path userGlobalConfig = System.getenv("XDG_CONFIG_HOME") != null ? Paths.get(System.getenv("XDG_CONFIG_HOME"), APP_NAME, "config") : Paths.get(System.getProperty("user.home"), ".config", APP_NAME, "config");
        if (arguments.containsKey(ARG_CONFIG_DATA) && arguments.get(ARG_CONFIG_DATA) != null) {
            if (!"".equals(arguments.get(ARG_CONFIG_DATA)) && !((String)arguments.get(ARG_CONFIG_DATA)).contains(":")) {
                arguments.put(ARG_CONFIG_DATA, "extends: " + arguments.get(ARG_CONFIG_DATA));
            }
            this.conf = new YamlLintConfig((String)arguments.get(ARG_CONFIG_DATA));
        } else {
            this.conf = arguments.containsKey(ARG_CONFIG_FILE) && arguments.get(ARG_CONFIG_FILE) != null ? new YamlLintConfig(new File((String)arguments.get(ARG_CONFIG_FILE)).toURI().toURL()) : (this.fileExists(USER_CONF_FILENAME) ? new YamlLintConfig(new File(USER_CONF_FILENAME).toURI().toURL()) : (this.fileExists(userGlobalConfig.toString()) ? new YamlLintConfig(userGlobalConfig.toUri().toURL()) : new YamlLintConfig("extends: default")));
        }
    }

    private List<File> findFilesRecursively(String[] items) {
        ArrayList<File> files = new ArrayList<File>();
        for (String item : items) {
            File file = new File(item);
            if (file.isDirectory()) {
                files.addAll(this.findFilesRecursively(Arrays.stream(file.list()).map(name -> file.getPath() + File.separator + name).collect(Collectors.toList()).toArray(new String[0])));
                continue;
            }
            if (!file.isFile() || !item.endsWith(".yml") && !item.endsWith(".yaml")) continue;
            files.add(file);
        }
        return files;
    }

    private boolean fileExists(String path) {
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    private void showHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((o1, o2) -> 1);
        PrintWriter pw = new PrintWriter(this.errout);
        formatter.printHelp(pw, 80, "yamllint [-h] [-v] [-c <config_file> | -d <config_data>] [-f <format>] [-s] FILE_OR_DIR ...", "\nA linter for YAML files. yamllint does not only check for syntax validity, but for weirdnesses like key repetition and cosmetic problems such as lines length, trailing spaces, indentation, etc.\n\nOptions:", options, 1, 3, null);
        pw.flush();
        System.exit(1);
    }

    private void endOnError(String message, Options options) {
        this.err("Error: " + message);
        if (options != null) {
            this.showHelpAndExit(options);
        } else {
            System.exit(1);
        }
    }

    private void out(String message) {
        try {
            this.stdout.write(message.getBytes());
            this.stdout.write(System.lineSeparator().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(this.errout));
            System.exit(1);
        }
    }

    private void err(String message) {
        try {
            this.errout.write(message.getBytes());
            this.errout.write(System.lineSeparator().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

