/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.LintProblem;
import java.util.Collections;

public class Format {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_FAINT = "\u001b[2m";
    public static final String ANSI_UNDERLINED = "\u001b[4m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";

    private Format() {
    }

    public static String parsable(LintProblem problem, String filename) {
        return String.format("%1$s:%2$d:%3$d:%4$s:%5$s:%6$s", filename, problem.getLine(), problem.getColumn(), problem.getRuleId() == null ? "" : problem.getRuleId(), problem.getLevel() == null ? "" : problem.getLevel(), problem.getDesc());
    }

    public static String standard(LintProblem problem) {
        StringBuilder line = new StringBuilder();
        line.append("  ").append(problem.getLine()).append(":").append(problem.getColumn());
        line.append(Format.getFiller(Math.max(12 - line.length(), 0)));
        if (problem.getLevel() != null) {
            line.append(problem.getLevel());
        }
        line.append(Format.getFiller(Math.max(21 - line.length(), 0)));
        line.append(problem.getDesc());
        if (problem.getRuleId() != null) {
            line.append("  (").append(problem.getRuleId()).append(")");
        }
        return line.toString();
    }

    public static String standardColor(LintProblem problem) {
        StringBuilder line = new StringBuilder();
        line.append("  ").append(ANSI_FAINT).append(problem.getLine()).append(":").append(problem.getColumn()).append(ANSI_RESET);
        line.append(Format.getFiller(Math.max(20 - line.length(), 0)));
        if (problem.getLevel() != null) {
            if ("warning".equals(problem.getLevel())) {
                line.append(ANSI_YELLOW).append(problem.getLevel()).append(ANSI_RESET);
            } else if ("error".equals(problem.getLevel())) {
                line.append(ANSI_RED).append(problem.getLevel()).append(ANSI_RESET);
            } else {
                line.append(problem.getLevel());
            }
        }
        line.append(Format.getFiller(Math.max(38 - line.length(), 0)));
        line.append(problem.getDesc());
        if (problem.getRuleId() != null) {
            line.append("  ").append(ANSI_FAINT).append("(").append(problem.getRuleId()).append(")").append(ANSI_RESET);
        }
        return line.toString();
    }

    public static boolean supportsColor() {
        boolean supportedPlatform = !System.getProperty("os.name").toLowerCase().contains("windows") || System.getenv("ANSICON") != null || System.getenv("TERM") != null && "ANSI".equals(System.getenv("TERM"));
        return supportedPlatform && System.console() != null;
    }

    public static String getFiller(int length) {
        return Format.repeat(length, " ");
    }

    public static String repeat(int n, String s) {
        return String.join((CharSequence)"", Collections.nCopies(n, s));
    }
}

