/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.YamlLintConfigException;
import com.github.sbaudoin.yamllint.rules.Rule;
import com.github.sbaudoin.yamllint.rules.RuleFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nonnull;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlLintConfig {
    public static final String EXTENDS_KEY = "extends";
    public static final String YAML_FILES_KEY = "yaml-files";
    public static final String IGNORE_KEY = "ignore";
    public static final String RULES_KEY = "rules";
    protected Map<String, Object> ruleConf;
    protected List<String> ignore = null;
    protected List<String> yamlFiles = Arrays.asList(".*\\.yaml$", ".*\\.yml$");

    public YamlLintConfig(String content) throws YamlLintConfigException {
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        this.parse(content);
        this.validate();
    }

    public YamlLintConfig(URL file) throws IOException, YamlLintConfigException {
        if (file != null) {
            try (Scanner scanner = new Scanner(file.openStream()).useDelimiter("\\A");){
                this.parse(scanner.next());
            }
        } else {
            throw new IllegalArgumentException("content cannot be null");
        }
        this.validate();
    }

    public boolean isYamlFile(String filepath) {
        return this.yamlFiles.stream().anyMatch(filepath::matches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFileIgnored(String filepath) {
        if (this.ignore == null) return false;
        if (!this.ignore.stream().anyMatch(filepath::matches)) return false;
        return true;
    }

    public List<Rule> getEnabledRules(File file) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Map.Entry<String, Object> entry : this.ruleConf.entrySet()) {
            Rule rule = RuleFactory.instance.getRule(entry.getKey());
            if (rule == null || entry.getValue() == null || file != null && rule.ignores(file)) continue;
            rules.add(rule);
        }
        return rules;
    }

    public Object getRuleConf(String id) {
        return this.ruleConf.get(id);
    }

    public void extend(YamlLintConfig baseConfig) {
        assert (this.ruleConf != null);
        HashMap<String, Object> newConf = new HashMap<String, Object>(baseConfig.ruleConf);
        for (Map.Entry<String, Object> entry : this.ruleConf.entrySet()) {
            String ruleId = entry.getKey();
            Object conf = entry.getValue();
            if (conf instanceof Map && newConf.get(ruleId) != null) {
                YamlLintConfig.deepMerge((Map)newConf.get(ruleId), (Map)conf);
                continue;
            }
            newConf.put(ruleId, conf);
        }
        this.ruleConf = newConf;
        if (baseConfig.yamlFiles != null) {
            this.yamlFiles = baseConfig.yamlFiles;
        }
        if (baseConfig.ignore != null) {
            this.ignore = baseConfig.ignore;
        }
    }

    protected void parse(String rawContent) throws YamlLintConfigException {
        Map conf;
        try {
            conf = (Map)new Yaml().load(rawContent);
        }
        catch (ClassCastException | YAMLException e) {
            throw new YamlLintConfigException("invalid YAML config: " + e.getMessage(), e);
        }
        if (conf == null) {
            throw new YamlLintConfigException("invalid config: not a dictionary");
        }
        this.ruleConf = conf.getOrDefault(RULES_KEY, new HashMap());
        if (conf.containsKey(EXTENDS_KEY)) {
            try {
                YamlLintConfig base = new YamlLintConfig(this.getExtendedConfigFile((String)conf.get(EXTENDS_KEY)));
                this.extend(base);
            }
            catch (IllegalArgumentException e) {
                throw new YamlLintConfigException("invalid extends config: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new YamlLintConfigException("invalid extends config (unknown error): " + e.getMessage(), e);
            }
        }
        if (conf.containsKey(YAML_FILES_KEY)) {
            if (!(conf.get(YAML_FILES_KEY) instanceof List)) {
                throw new YamlLintConfigException("invalid config: 'yaml-files' must be a list (of regexp patterns)");
            }
            this.yamlFiles = (List)conf.get(YAML_FILES_KEY);
        }
        if (conf.containsKey(IGNORE_KEY)) {
            if (!(conf.get(IGNORE_KEY) instanceof String)) {
                throw new YamlLintConfigException("invalid config: 'ignore' should contain file patterns");
            }
            this.ignore = Arrays.asList(((String)conf.get(IGNORE_KEY)).split("\\r?\\n"));
        }
    }

    protected void validate() throws YamlLintConfigException {
        for (Map.Entry<String, Object> entry : this.ruleConf.entrySet()) {
            String id = entry.getKey();
            Rule rule = RuleFactory.instance.getRule(id);
            if (rule == null) {
                throw new YamlLintConfigException("invalid config: no such rule: \"" + id + "\"");
            }
            Map<String, Object> newConf = YamlLintConfig.validateRuleConf(rule, entry.getValue());
            this.ruleConf.put(id, newConf);
        }
    }

    protected static Map<String, Object> validateRuleConf(Rule rule, Object conf) throws YamlLintConfigException {
        if (conf == null || "disable".equals(conf)) {
            return null;
        }
        if ("enable".equals(conf)) {
            conf = new HashMap();
        }
        if (conf instanceof Map) {
            Map mapConf = conf;
            if (mapConf.containsKey(IGNORE_KEY)) {
                if (mapConf.get(IGNORE_KEY) instanceof List) {
                    rule.setIgnore((List)mapConf.get(IGNORE_KEY));
                } else {
                    if (!(mapConf.get(IGNORE_KEY) instanceof String)) {
                        throw new YamlLintConfigException("invalid config: ignore should contain regexp patterns");
                    }
                    rule.setIgnore(Arrays.asList(((String)mapConf.get(IGNORE_KEY)).split("\\r?\\n")));
                }
            }
            if (!mapConf.containsKey("level")) {
                rule.setLevel("error");
                mapConf.put("level", "error");
            } else if (mapConf.containsKey("level") && ("error".equals(mapConf.get("level")) || "warning".equals(mapConf.get("level")) || "info".equals(mapConf.get("level")))) {
                rule.setLevel((String)mapConf.get("level"));
            } else {
                throw new YamlLintConfigException("invalid config: level should be \"error\", \"warning\" or \"info\"");
            }
            Map<String, Object> options = rule.getOptions();
            for (Map.Entry entry : mapConf.entrySet()) {
                String optkey = (String)entry.getKey();
                if (IGNORE_KEY.equals(optkey) || "level".equals(optkey)) continue;
                if (!options.keySet().contains(optkey)) {
                    throw new YamlLintConfigException("invalid config: unknown option \"" + optkey + "\" for rule \"" + rule.getId() + "\"");
                }
                if (options.get(optkey) instanceof List) {
                    if (!((List)options.get(optkey)).contains(mapConf.get(optkey)) && ((List)options.get(optkey)).stream().noneMatch(object -> entry.getValue().getClass().equals(object))) {
                        throw new YamlLintConfigException("invalid config: option \"" + optkey + "\" of \"" + rule.getId() + "\" should be in " + YamlLintConfig.getListRepresentation((List)options.get(optkey)));
                    }
                } else if (!mapConf.get(optkey).getClass().equals(options.get(optkey))) {
                    throw new YamlLintConfigException("invalid config: option \"" + optkey + "\" of \"" + rule.getId() + "\" should be of type " + options.get(optkey).getClass().getSimpleName().toLowerCase());
                }
                rule.addParameter(optkey, mapConf.get(optkey));
            }
            for (String optkey : options.keySet()) {
                if (mapConf.containsKey(optkey)) continue;
                throw new YamlLintConfigException("invalid config: missing option \"" + optkey + "\" for rule \"" + rule.getId() + "\"");
            }
            return mapConf;
        }
        throw new YamlLintConfigException("invalid config: rule \"" + rule.getId() + "\": should be either \"enable\", \"disable\" or a dictionary");
    }

    protected URL getExtendedConfigFile(String name) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("need to extend something");
        }
        if (!name.contains(File.separator)) {
            URL url = this.getClass().getClassLoader().getResource("conf/" + name + ".yaml");
            if (url == null) {
                throw new IllegalArgumentException("Bundled configuration file \"" + name + "\" not found");
            }
            return url;
        }
        try {
            return new File(name.replace('/', File.separatorChar)).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot create URL for the configuration file \"" + name + "\"", e);
        }
    }

    protected static String getListRepresentation(@Nonnull List list) {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (o instanceof String) {
                sb.append("'").append(o).append("'");
                continue;
            }
            if (o instanceof Class) {
                sb.append(((Class)o).getSimpleName().toLowerCase());
                continue;
            }
            sb.append(o);
        }
        return sb.append("]").toString();
    }

    protected static Map<Object, Object> deepMerge(Map<Object, Object> original, Map<Object, Object> newMap) {
        for (Map.Entry<Object, Object> entry : newMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof Map && original.get(key) instanceof Map) {
                original.put(key, YamlLintConfig.deepMerge((Map)original.get(key), (Map)value));
                continue;
            }
            if (key instanceof List && original.get(key) instanceof List) {
                List originalChild = (List)original.get(key);
                for (Object each : (List)value) {
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            original.put(key, value);
        }
        return original;
    }
}

