/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.Token;

public class Commas
extends TokenRule {
    public static final String OPTION_MAX_SPACES_BEFORE = "max-spaces-before";
    public static final String OPTION_MIN_SPACES_AFTER = "min-spaces-after";
    public static final String OPTION_MAX_SPACES_AFTER = "max-spaces-after";

    public Commas() {
        this.options.put(OPTION_MAX_SPACES_BEFORE, Integer.class);
        this.options.put(OPTION_MIN_SPACES_AFTER, Integer.class);
        this.options.put(OPTION_MAX_SPACES_AFTER, Integer.class);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (token instanceof FlowEntryToken) {
            LintProblem problem;
            if (prev != null && (Integer)conf.get(OPTION_MAX_SPACES_BEFORE) != -1 && prev.getEndMark().getLine() < token.getStartMark().getLine()) {
                problems.add(new LintProblem(token.getStartMark().getLine() + 1, Math.max(1, token.getStartMark().getColumn()), "too many spaces before comma"));
            } else {
                problem = this.spacesBefore(token, prev, -1, (int)((Integer)conf.get(OPTION_MAX_SPACES_BEFORE)), null, "too many spaces before comma");
                if (problem != null) {
                    problems.add(problem);
                }
            }
            problem = this.spacesAfter(token, next, (int)((Integer)conf.get(OPTION_MIN_SPACES_AFTER)), (int)((Integer)conf.get(OPTION_MAX_SPACES_AFTER)), "too few spaces after comma", "too many spaces after comma");
            if (problem != null) {
                problems.add(problem);
            }
        }
        return problems;
    }
}

